// 编译命令
// gcc -o ten264_example_reconfig ten264_example_reconfig.c -I ../lib/ -L ../lib/ -ltscsdk_center -ldl -lpthread -lm -lz -lrt
// 运行方法
// ten264_example_reconfig nv12.yuv ten264_example_reconfig.h264 [rate_control_method: crf or vbv_crf]
// 例如
// ten264_example_reconfig nv12.yuv ten264_example_reconfig.h264 crf
// ten264_example_reconfig nv12.yuv ten264_example_reconfig.h264 vbv_crf

#include "ten264_example_common.h"


int main(int argc, char **argv) {
    FILE *file_in = NULL, *file_out = NULL;
    int width = 1920, height = 1080;
    char *rc_method = "crf";
    ten264_param_t params;
    ten264_t *enc = NULL;
    void *extra = NULL;
    ten264_picture_t pic;

    /* Check args */
    FAIL_IF_ERROR(parse_args(argc, argv, &rc_method) != 0, "Example usage: \n"
        "ten264_example input.yuv output.h264 "
        "[rate_control_method: crf or vbv_crf] \n");

    /* Open files */
    FAIL_IF_ERROR(open_file(&file_in, argv[1], &file_out, argv[2]) != 0, "");

    /* Configure base params */
    FAIL_IF_ERROR(ten264example_prarm_init(&params, width, height) != 0, "");

    /* crf参数可选： 21.5, 26.6, 31.7, 36 */
    if (strcmp(rc_method, "vbv_crf") == 0) {
        FAIL_IF_ERROR(ten264example_rc_method_vbv_crf(&params, "21.5", 400) != 0, "");
    } else if (strcmp(rc_method, "crf") == 0) {
        FAIL_IF_ERROR(ten264example_rc_method_crf(&params, "21.5") != 0, "");
    }

    /* Parse params */
    const char ten264_param[] = "threads=4:keyint=infinite:p-opt=1,0,4,1.5:tune=zerolatency_shxf";
    FAIL_IF_ERROR(ten264example_param_parse(&params, ten264_param) != 0, "");
    
    /* Open encoder */
    FAIL_IF_ERROR(!(enc = ten264_encoder_open(&params, &extra, "../sdk_config")),
        "ten264_encoder_open failed.\n");

    /* Configure input picture */
    ten264example_picture_init_nv12(&pic, &params);

    /* Get h264 headers */
    FAIL_IF_ERROR(ten264example_get_header(enc, file_out) != 0, "");
    
    /* Encode frames */
    while (true) {

        /* Read input frame */
        if (ten264example_read_frame_nv12(&pic, &params, file_in) != 0)
            break;

        /* Update pts */
        pic.i_pts++;

/*************************** different code ***************************/
        /* Reconfig example */
        /* reconfig after the 60th frame */
        if (pic.i_pts == 60) {
            if (strcmp(rc_method, "vbv_crf") == 0) {
                FAIL_IF_ERROR(ten264example_rc_method_vbv_crf(&params, "36", 200) != 0, "");
            } else if (strcmp(rc_method, "crf") == 0) {
                FAIL_IF_ERROR(ten264example_rc_method_crf(&params, "36") != 0, "");
            }
            FAIL_IF_ERROR(ten264_encoder_reconfig(enc, &params) < 0, 
                "ten264_encoder_reconfig failed.\n");
        }
/*************************** different code ***************************/

        /* Encode frame */
        FAIL_IF_ERROR(ten264example_encode_frame(enc, &pic, extra, file_out) != 0, "");
    }

    /* Flush delayed frames */
    FAIL_IF_ERROR(ten264example_flush_encoder(enc, extra, file_out) != 0, "");

    /* Exit program */
    int ret = 0;
    goto success;

fail:
    ret = -1;
success:
    if (enc)
        ten264_encoder_close(enc, &extra);
    ten264example_picture_free(&pic);
    close_file(&file_in, &file_out);
    return ret;
}
