
/*****************************************************************************
 *Copyright(C) 2017 - 2021 Tencent.
 *All Rights Reserved.
 ****************************************************************************/

#ifndef SOURCE_LIB_INC_TEN265_H_
#define SOURCE_LIB_INC_TEN265_H_

#include <stdarg.h>
#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>
#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

//for 265
/************* Version information *************/
// clang-format off

#define TEN265_LOG_NONE                   (-1)
#define TEN265_LOG_ERROR                   0
#define TEN265_LOG_WARNING                 1
#define TEN265_LOG_INFO                    2
#define TEN265_LOG_DEBUG                   3
/******************** macro ********************/

#define TEN265_LOOKAHEAD_MAX               250

//gop struct type
#define TEN265_RANDOMACCESS                1
#define TEN265_LOWDELAYP                   2
#define TEN265_LOWDELAYB                   3
#define TEN265_ALLINTRAS                   4

//aqmode type
#define TEN265_AQ_NONE                     0
#define TEN265_AQ_VARIANCE                 1
#define TEN265_AQ_AUTO_VARIANCE            2
#define TEN265_AQ_AUTO_VARIANCE_BIASED     3
#define TEN265_BFRAME_MAX                  16

// lookahead frame type
#define TEN265_TYPE_AUTO                  0
#define TEN265_TYPE_IDR                   1
#define TEN265_TYPE_I                     2
#define TEN265_TYPE_P                     3
#define TEN265_TYPE_BREF                  4
#define TEN265_TYPE_B                     5

#define TEN_NAL_UNIT_CODED_SLICE_BLA_W_LP    16
#define TEN_NAL_UNIT_CODED_SLICE_BLA_W_RADL  17
#define TEN_NAL_UNIT_CODED_SLICE_BLA_N_LP    18
#define TEN_NAL_UNIT_CODED_SLICE_IDR_W_RADL  19
#define TEN_NAL_UNIT_CODED_SLICE_IDR_N_LP    20
#define TEN_NAL_UNIT_CODED_SLICE_CRA         21

// clang-format on
/****************** sei **********************/
typedef struct ten265_sei_payload_tag {
  int32_t payload_size;
  int32_t nal_type;  // DATA_NALS
  uint8_t *payload;
} ten265_sei_payload_t;

typedef struct ten265_sei_tag {
  int32_t num_payloads;
  ten265_sei_payload_t *payloads;
  /* In: optional callback to free each payload AND ten265_sei_payload_t when used. */
  void (*sei_free)(void *);
} ten265_sei_t;

/****************** structure ******************/
typedef struct ten265_inpic_tag {
  int32_t i_type;
  int64_t i_pts;
  int32_t stride[3];
  void *plane[3];
  float rate_factor_offset;
  float *quant_offsets;  // quant_offsets of the 16x16 blocks in the pic
  ten265_sei_t extra_sei;
  void *opaque;
  int64_t m_startTimeCalcDelay;  // calc the delay time
} ten265_inpic_t;

typedef struct ten265_nal_tag {
  int32_t i_type;
  int32_t i_payload;
  uint8_t *payload;
} ten265_nal_t;

typedef struct ten265_outpic_tag {
  int32_t i_type;
  int64_t i_pts;
  int64_t i_dts;
  uint8_t *bitstream;
  int32_t i_nal;
  ten265_nal_t nal[32];
  double psnr[3];
  double ssim[3];
  void *opaque;
} ten265_outpic_t;

typedef struct ten265_gop_tag {
  int32_t m_POC;
  int32_t m_QPOffset;
  double m_QPFactor;
  int32_t m_temporalId;
  int32_t m_level;
  int32_t m_bRefPic;
  int32_t m_numRefPicsActive;
  int8_t m_sliceType;
  int32_t m_numRefPics;
} ten265_gop_t;

/* encoder parameters */

typedef struct ten265_param_t {
    int32_t m_bit_depth;
    int32_t m_internal_bit_depth;
    int32_t m_adapt_bit_depth;
    int32_t m_preset;
    int32_t m_iPad8Width;
    int32_t m_iPad8Height;
    int32_t m_iSourceWidth;
    int32_t m_iSourceHeight;
    int32_t m_iSourceHeightLower;
    int32_t m_iFpsNum;
    int32_t m_iFpsDenom;
    int32_t m_iTimeBaseNum;
    int32_t m_iTimeBaseDen;
    int32_t m_bLiveStreamingVUI;
    int32_t m_framesToBeEncoded;
    int32_t m_iRoiMode;
    double m_fRatefactorOffset;
    int32_t m_iRfPeriod;
    double m_fROIStrength;
    int32_t m_vfr_input;
    int32_t m_iPtsForceIncrease;
    char *m_pchInputFile;      // please alloc by strdup and it will be released by t265_param_free
    char *m_pchBitstreamFile;  // please alloc by strdup and it will be released by t265_param_free
    char *m_pchReconFile;      // please alloc by strdup and it will be released by t265_param_free
    char *m_2passPath;         // please alloc by strdup and it will be released by t265_param_free

    int32_t m_iUsePrecise2PassInfo;  // Write precisely pass1 info.
    int32_t read_buf_cnt;
    double low_bitspp_thers;
    int m_ripping_config;

    // 0: Inherit pass1 qscale. 1. Use only pass1 info calc qscale. 2: Blend pass1 & lookahead info.
    int32_t m_iCrf2PassStrategy;
    double m_iCrf2PassAlpha;
    double m_iCrf2PassBeta;
    double m_iCrf2PassGamma;

    char m_tune[20];
    int32_t m_levelTier;
    int32_t m_level;
    int32_t m_iGOPSize;
    int32_t m_bEnableGop4;
    int32_t m_bFirstGopMaxSize;
    int32_t m_bFirstGopPeriod;
    int32_t m_iGOPType;
    int32_t m_enableAMP;
    int32_t m_uiQuadtreeTUMaxDepthInter;
    int32_t m_uiQuadtreeTUMaxDepthIntra;
    int32_t m_bCameraSpeed;
    int32_t m_bEnableLoopFilter;
    int32_t m_bUseSAO;
    int32_t m_iUseRDOQ;
    int32_t m_iUseRDOQTS;
    int32_t m_iWaveFrontSynchro;
    int32_t m_decodedPictureHashSEIEnabled;
    int32_t m_iMaxNumMergeCand;
    int32_t m_iTMVPModeId;
    int32_t m_iSignHideFlag;
    int32_t m_iCabacInitPresentMethod;
    int32_t m_frameNumThreads;
    int32_t m_noiseFrames;
    double m_maxNoiseLevel;
    int32_t m_poolThreads;
    uint64_t m_poolMask;
    int32_t m_iMaxReference;
    int32_t m_iMaxRefBiDir;
    int32_t m_iFppReduce;
    int32_t m_iLongTerm;
    int32_t m_iLongTermClipIqp;
    int32_t m_bFfmpegLongterm;
    int32_t m_bAdaptiveGOP;
    int32_t m_bCutGopPowerOfTwo;
    int32_t m_iGopTruncateThresh;
    int32_t m_iDpbErrorResilience;
    int32_t m_iMaxBframe;
    int32_t m_iAlignInputType;
    int32_t m_iLookaheadLength;
    int32_t m_iLookaheadDelay;
    int32_t m_scenecutThreshold;
    int32_t m_iOpenGOP;
    int32_t m_keyframeMax;
    int32_t m_keyfpsperiod;
    int32_t m_keyframeMin;
    int32_t m_bRoundKeyint;
    int32_t m_intraRefresh;
    int32_t m_IRCount;
    int32_t m_bRepeatHeaders;
    int32_t m_iRateControlMode;
    int32_t m_iQP;
    int32_t m_iLookaheadQp;
    double m_lookaheadQpScale;
    double m_lookaheadQpOffset;
    int32_t m_fRCTargetBitRate;
    double m_rfConstant;
    double m_rfConstantMax;
    double m_rfConstantMin;
    int32_t m_force_vfr_input;
    int32_t m_aqMode;
    double m_aqStrength;  // when tuing vmaf, 1.0 is suggested
    int32_t m_cuTree;
    double m_fCutreeStrength;  // when tuing vmaf,should be smaller
    int32_t m_iCuAdaptiveLambdaPos;
    int32_t m_iCuAdaptiveLambdaNeg;
    int32_t m_iCuAdaptiveLambdaFactor;
    int32_t m_iRCConsist;
    int32_t m_iRCSyncMultiFrame;
    int32_t m_bRCSliceQpOpt;
    int32_t m_adaptqscale;
    int32_t m_adaptqscalesimpleoffset;
    int32_t m_darkscene_qpthres[2];
    int32_t m_adaptsatdweight;
    int32_t m_multipassCuInfoInFile;
    int32_t m_bStatWrite;
    int32_t m_bStatRead;
    int32_t m_iPass1DownSample;
    int32_t m_bKeep2passlog;
    int32_t m_iPass2Cutree;
    int32_t m_iPass2Arnr;
    int32_t m_iNoiseLevelThresh;
    double m_fNoisyFrameFrac;
    double m_fResScalePower;
    double m_fResScalePowerLow;
    double m_fResScalePowerHigh;
    double m_qCompress;
    double m_qCompressFirst;
    double m_cplxrSumFactor;
    double m_depreciateRate;
    double m_ipFactor;  // 1.0~1.4
    double m_pbFactor;
    int32_t m_uv_offset_opt;
    int32_t m_uv_useStateFile;
    double m_uv_ratio_thres;
    double m_uv_ratio_alpha;
    double m_uv_ratio_beta;
    double m_uv_sse_weight;
    int32_t m_vbvMaxBitrate;
    double m_vbvmaxrateperiod;
    double m_vbvbufsizeperiod;
    int32_t m_vbvBufferSize;
    double m_vbvBufferInit;
    double m_vbvBufferRecover;
    int32_t m_vbvInitPeriod;
    int32_t m_ctuVbvControl;
    double m_vbvPredictorWeight[3];
    double m_vbvPredictorMinWeight[3];
    int32_t m_bAdaptivePeakRatetol;
    double m_fPeakRatetol;  // 0.2~1.0
    double m_fRatetol;      // 0.01~1.0
    int32_t m_isZeroLatency;
    int32_t m_qpMax;
    int32_t m_qpMin;
    int32_t m_qpMaxI;
    int32_t m_qpMinI;
    int32_t m_qpMinScale;
    int32_t m_qpInitMax;
    int32_t m_qpInitMin;
    int32_t m_vuiParametersPresentFlag; /* enable generation of VUI parameters */
    int32_t m_aspectRatioIdc;           /* aspect_ratio_idc */
    int32_t m_sarWidth;                 /* horizontal size of the sample aspect ratio */
    int32_t m_sarHeight;                /* vertical size of the sample aspect ratio */
    int32_t m_videoSignalTypePresentFlag;
    int32_t m_videoFormat;
    int32_t m_videoFullRangeFlag;
    int32_t m_colourDescriptionPresentFlag;
    int32_t m_colourPrimaries;
    int32_t m_transferCharacteristics;
    int32_t m_matrixCoefficients;
    int32_t m_iSmallQPLimitAq;
    int32_t m_iAdaptPsnrSsim;
    int32_t m_iLHSatdScale;
    int32_t m_iPreSearchRange;
    int32_t m_iAdaptCutree;
    int32_t m_iBitsCompenBeforeI;
    /* Log */
    int32_t m_logLevel;
    void (*pf_log)(void *, int i_level, const char *psz, va_list);
    void *p_log_private;

    int32_t m_logPSNR;
    int32_t m_logSSIM;
    int32_t m_logRCtrace;
    int32_t m_ssimMethod;
    int32_t m_bEnableStartupYUVCache;
    int32_t m_t265CopyRightInfo;
    int32_t m_recoverySEI;
    int32_t m_iAdaptInterpQpcrf;
    int32_t m_iAdaptInterpRc;
    int32_t m_qpStep;
    double m_qblur;          /* temporally blur quants */
    double m_complexityBlur; /* temporally blur complexity */
    double m_fRcWaitRatio[2];
    int32_t m_bIcompenWin;
    int32_t m_iAdaptiveVBV;
    int32_t m_adaptqcomp;
    int32_t m_bAdaptivePBRatio;  // 1:open for single pass and first pass, 2: open for all passes
                                 // and qpfactor estimation
    int32_t m_bAdaptiveIPRatio;  // 1:open for single pass and first pass, 2: open for all passes
                                 // and qpfactor estimation
    int32_t m_iRCSyncDist;
    double m_fBitrateScale;
    int32_t m_iPreSearchMethod;
    int32_t m_confEnable;
    int32_t m_confWinLeft;
    int32_t m_confWinRight;
    int32_t m_confWinTop;
    int32_t m_confWinBottom;
    ten265_gop_t *m_GOPList;
    uint8_t m_maxDecPicBuffering[7];
    uint8_t m_numReorderPics[7];
    int32_t m_bOnly16bitFrameInterpolation;
    int32_t m_interpolationLevel;
    int32_t m_maxTempLayer;  ///< Max temporal layer
    int32_t m_maxGopDepth;
    int32_t m_loopFilterOffsetInPPS;
    int32_t m_loopFilterBetaOffsetDiv2;
    int32_t m_loopFilterTcOffsetDiv2;
    int32_t m_maxNumOffsetsPerPic;
    int32_t m_iGPBEnable;
    int32_t m_iFastSearch;
    int32_t m_iSearchRange;
    int32_t m_bipredSearchRange;
    int32_t m_iBiPredOverflowFactor;
    int32_t m_iMaxCuDQPDepth[4];  //  Max. depth for a minimum CuDQP (0:default)
    int32_t m_iAdaptDqpDepth;     // adaptive max dqp depth for different frames
    int32_t m_iDqpVarFracThres;
    int32_t m_iDqpIntraCostThres;
    int32_t m_iDqpSmallIntraCost;
    int32_t m_iQpRefine;
    int32_t m_iMvRefine;  // 1. Uni-diretional mvrefine with fast algorithm, 2. uni-directional
                          // mvrefine, 4. bi-directional mvrefine
    int32_t m_bNonsqMvRefine;
    int32_t m_iRefListRefine;
    int32_t m_iRefListRdo;
    int32_t m_iRefListRdoMinNum;
    int32_t m_iRefListRdoSkipSame;
    int32_t m_iRefListRdoEarlySkipThr;
    int32_t m_iRefListDoubleCheck;
  int32_t m_cbQpOffset;
  int32_t m_crQpOffset;
  int32_t m_bUseHADME;
  int32_t m_bEarlyStopInterRdo;
  int32_t m_iSkipRdoqInter[5];  //
  int32_t m_iFastRdoqInter[4];   //
  int32_t m_iSkipRdoqIntra[5];  //
  int32_t m_iFastRdoqIntra[4];   //
  int32_t m_useFastDecisionForMerge;
  int32_t m_useTransformSkip;
  int32_t m_interSatd2Sad;
  int32_t m_freqDomainCost[5];  //
  int32_t m_iAdaptMrgNum;
  int32_t m_iqp2qstepbetter;  // the smaller the better
  int32_t m_iqp2qstepfaster;  // the smaller the faster
  int32_t m_bInterCheckMerge;
  int32_t m_iDisNonSquarePartMode;
  int32_t m_iPruneRectFromRdcost;
  int32_t m_iSkipAmpDepth;
  int32_t m_bSetAmpShape;
  int32_t m_iPruneAmpFromRdcost;
  int32_t m_iSkipAmpBaseCost[5];
  int32_t m_iSkipIntraFromPreAnalysis[5];  //
  int32_t m_iDisNxNLevel;
  int32_t m_bFastPuAfterMerge;
  int32_t m_iSkipIntraFromDist[4];  //
  int32_t m_iDisCurrSaoType[5];
  int32_t m_iDisNoRefFrameSAO;
  int32_t m_iDisSaoUseFrametype[5];  //
  int32_t m_iDisFrameSAO;                        //
  int32_t m_iTuEarlyStopPu;
  int32_t m_iEarlySkipAfter2Nx2N;
  int32_t m_iSkipOtherInterAfter2Nx2N;
  int32_t m_iCorrectCbfRdo;
  int32_t m_iCbfSkipPu;
  int16_t m_iQP2Qstep[52];
  int16_t m_iQP2Qstep2[52];
  int16_t m_iQP2Qstepb2[52];
  int32_t m_iSkip2nRatio[5];        //
  int32_t m_iSkip2nfromSubCost[5];  //
  int32_t m_iSkip2nAllmergeskip;
  int32_t m_iSkipSubfromSkip2n;
  int32_t m_iSubdiffSkipAMP[4 + 1];   //
  int32_t m_iSubdiffSkipSub[4];       //
  int32_t m_iSubdiffSkipSubRatio[4];  //
  int32_t m_iNborDCostSkipIntra[4];   //
  int32_t m_iStopSubMaxCostTh[4];     //
  int32_t m_iCostSkipSub[4];          //
  int32_t m_iDistSkipSub[4];          //
  int32_t m_iPruneSplitFromRdcost;
  int32_t m_iSkipSubNoCbf;
  int32_t m_bMvStartPointModify;
  int32_t m_bMvInfo2pass;
  int32_t m_bImeResultCorrect;
  int32_t m_bFmeResultCorrect;
  int32_t m_bEnableFastPU;
  int32_t m_iMultiRefFast;
  uint32_t m_iMultiRefFastThresh;
  uint32_t m_iMultiRefFast2nx2nThresh;
  int32_t m_iBiMultiRefFast;
  uint32_t m_iBiMultiRefFastThr;
  int32_t m_iFastSubQme;
  int32_t m_iQmeGuideFast;
  int32_t m_iUniFmeSkip;
  int32_t m_iUniMeSkip;  // skip uni ME
  int32_t m_iFastHme;
  int32_t m_iQmeRefineIters;
  int32_t m_iSkipLookAheadFrac;
  int32_t m_iLookAheadHMVP;
  int32_t m_iHMVPThreshold;
  int32_t m_iLookAheadEarlySkip;
  int32_t m_iLHSatdScaleMvp;  // when tunning vmaf, should be zero.
  int32_t m_iLHSatdScaleTh;   // when tunning vmaf, should be zero.
  int32_t m_iLHSatdScaleTh2;
  int32_t m_iSkipQme[4];  //
  int32_t m_iMeEarlySkipRatio;
  int32_t m_iFastQmeNumBaseFrameType[5];  //
  int32_t m_bFasterFME;
  int32_t m_iAdaptHmeRatio[5];
  int32_t m_bUpdataCalcCostDiff;
  int32_t m_iResetMeSearchRange;
  int32_t m_iClipMeSearchRange;
  int32_t m_iAdaptiveFmeAlg[4];  //
  int32_t m_iPreTzSearchRange;
  int32_t m_iPreAdaptiveTzThres;
  int32_t m_iPreAdaptiveTzMethod;
  int32_t m_bSkipBiPuSize8;
  int32_t m_iSkipIntraNxNFromRdcostDiff;
  int32_t m_iSkipIntraNxNFromChildSadDiff;
  int32_t m_iSkipIntraNxNinISliceFromChildSadDiff;
  int32_t m_iEarlySkipLowerIntraPred;
  int32_t m_iEarlySkipLowerIntraPred1;
  int32_t m_iUseScaledIntra64x64;
  int32_t m_iSkipSubFromFatherSkip;
  int32_t m_iStopInterFromSubTh[4 - 1];  //
  int32_t m_iFastFMEFromMerge;
  int32_t m_bEnableFastSkipSub;
  int32_t m_iEstimateCostSkipSub[4 - 1];
  int32_t m_iSkipCurFromSplit[4 - 1];  //
  int32_t m_iSkipCurFromMode[4 - 1];   //
  int32_t m_bFastMergeSkip;
  int32_t m_bSkipUV;
  int32_t m_iMergeSkipTh[4 + 2];
  int32_t m_iEarlyStopPuCheckTh[4];  //
  int32_t m_bDualDirCuIntra;
  int32_t m_bDualDirCuInter;
  int32_t m_iSubDiffThresh[4 - 1];          ////
  int32_t m_iTopDownContentTh[4 * 2 - 2];   //
  int32_t m_iBottomUpContentTh[4 * 2 - 2];  //
  int32_t m_iTopDownContentSkipSub[4 - 1];  //
  int32_t m_iSkipIntraFromCbf;
  int32_t m_iSkipIntraByNeiborIntraNum;
  int32_t m_bSkipFatherIntra;
  int32_t m_bSkipIntraFromRdCost;
  int32_t m_iStopIntraFromDist[4];  //
  int32_t m_iStopInterFromIntra[4];
  int32_t m_iAMPMergeRefine;
  int32_t m_bAddMeReuse;
  int32_t m_iBiRefNum;
  int32_t m_bDepthSkipCur;
  int32_t m_bCheckCurFromSubSkip;
  int32_t m_bDepthSkipSub;
  int32_t m_iStopCurFromNborCost;
  int32_t m_iStopSubFromNborNonSplitCost;
  int32_t m_iStopSubFromNborNonSplitCost2;
  int32_t m_iStopSubFromNborNonSplitCount;
  int32_t m_iFastQuantInter[4];
  int32_t m_iFastQuantIntra[4];
  int32_t m_iFastQuantInterChroma;
  int32_t m_iFastTuDecisionFromCbf;
  int32_t m_iPruneTuSplitIntraFromRdcost;
  int32_t m_iPruneTuSplitInterFromRdcost;
  int32_t m_iSkipTuSplit;
  int32_t m_iDisTuPart;
  int32_t m_iRdoqUVLambda[5 + 1];         //
  int32_t m_iAdaptiveSaoUVLambda[5 + 1];  //
  int32_t m_iSaoLambdaRatio[5 + 1];
  int32_t m_iOnlyIGPBRDOQ;
  int32_t m_iAdaptiveGOP4Ratio;
  int32_t m_iAdaptiveGOP8Ratio;
  int32_t m_iFadeSceneDetect;
  int32_t m_iIntraRatioAbrThresh16;
  int32_t m_iLargeMvAbrThresh16;
  int32_t m_iCostRatioAbrThresh16;
  int32_t m_iIntraRatioCbrThresh16;
  int32_t m_iLargeMvCbrThresh16;
  int32_t m_iCostRatioCbrThresh16;
  int32_t m_iAdaptGOPcostRatioThres;
  int32_t m_bEnableDeleteMrg2Nx2NSameMV;
  int32_t m_bEnableFastIntraModeOnlyPU64;
  int32_t m_bEnableIntraFirstChoice;
  int32_t m_bEnableIntraForIntraFirstChoice;
  int32_t m_iEnableIntraInInterPuNxNFastSkip;
  int32_t m_iRecombinationLumaSecondModeOptInInter[5];
  int32_t m_iRecombinationLumaSecondModeOptInIntra[5];
  int32_t m_bSecondModeNumOptUsePuSize[5];  //
  int32_t m_iChromaModeOptInInter[3];
  int32_t m_iChromaModeOptInIntra[3];
  int32_t m_iIntraCheckInInterFastSkipUseSubCu[2];
  int32_t m_iIntraCheckInInterFastSkipUseNborCu;
  int32_t m_iFirstIntraForPU;
  int32_t m_iFirstIntraRatio[5];
  int32_t m_iOnlyInterFromCuDepth[4];
  int32_t m_iSkipInterFromSub;
  int32_t m_iSkipRectForFirstIntra[5];
  int32_t m_iSkipAmpForFirstIntra[5];
  int32_t m_iOnlyInterForPU[5];
  int32_t m_iOnlyIntraForPU[5];
  int32_t m_iSkip2NForFirstIntra[5];
  int32_t m_iInterCheck2Nx2N;
  int32_t m_iFrameCuDepth[5 + 1];
  int32_t m_iFrameHDCuDepth[5 + 1];
  int32_t m_iFppRangeBottom;
  int32_t m_iFppRangeRight;
  double m_fppRightRatio;
  int32_t m_iAdaptFppRange;
  int32_t m_iMaxDPBSize;
  int32_t m_iDPBlimit;
  int32_t m_iUseStrongIntraSmoothing;
  int32_t m_iBackLongTerm;
  int32_t m_iHighQualityI;
  int32_t m_iEndJudgement;
  int32_t m_iEndofSeq;
  int32_t m_bFrameAdaptive;
  int32_t m_iScenecutSim;
  int32_t m_scenecutFilter;
  double m_scenecutBias;
  int32_t m_scenecutVerify;
  int32_t m_bBlackWhiteDetect;
  int32_t m_iLookaheadSlice;
  int32_t m_iLookaheadThreads;
  int32_t m_iThreadPolicy;
  int32_t m_iThreadPriority;
  int32_t m_bIgnoreNonzeroPolicy;
  int32_t m_iLookaheadPreset;
  int32_t m_iInterPreCuSize;
  int32_t m_iRefinePredictor;
  int32_t m_bCuInfoRead;
  int32_t m_bCuInfoWrite;
  void *m_pCuinfoinMemory;

  int32_t m_iFirstPassWidth;
  int32_t m_iFirstPassHeight;
  int32_t m_iFirstPassWidthInCtus;
  int32_t m_iFirstPassHeightInCtus;
  int32_t m_bRpsInSps;
  int32_t m_bitsForShortTermRPS;
  int32_t m_bSyncMaster;  // pcg idr align params
  int32_t m_iOnlyConfigLookahead;
  int m_iAlgControl;  // rc  distribution
  int m_iWritePBS;
  int m_iParamSsid;  // Slice ID
  int m_bHDRChromaQpOpt;
  int32_t m_bEmitHDRSEI; /* hdr 10bit */
  int32_t m_bEmitHRDSEI;
  char *m_userData;  // please alloc by strdup and it will be released by t265_param_free
  uint16_t m_maxCLL;
  uint16_t m_maxFALL;
  char *m_masteringDisplayColorVolume;  // please alloc by strdup and it will be released by
                                        // t265_param_free
  int32_t m_iDolbyProfile;
  int32_t m_bEnableAccessUnitDelimiters;

  // arnr parameters
  int32_t m_bEnableTemporalFilter;
  int32_t m_iTemporalFilterLevel;
  int32_t m_iTemporalFilterExt;
  int32_t m_iTemporalFilterGop;
  int32_t m_iTemporalFilterQp;
  int32_t m_iTemporalFilterThres[2];
  double m_fTemporalFilterRatio[3];
  int32_t m_useArnr;
  double m_arnrStrength;
  int32_t m_arnrFrames;
  int32_t m_arnrFramesExt;
  int32_t m_arnrFramesLimit;
  int32_t m_adaptArnrFrames;
  int32_t m_arnrFmeInterlace;
  int32_t m_arnrMeEarlySkipRatio;
  int32_t m_arnrPrune16x16Thr;
  int32_t m_arnrParallRows;
  int32_t m_arnrLookaheadMvp;
  int32_t m_arnrSimpleSceneThr;
  int32_t m_iArnrRefPicAdjustNum;
  double m_arnrRefFrameSize;
  double m_arnrDecaysParam[3];
  double m_arnrWindowErrorRatio;
  double m_arnrDfactorMin;
  double m_arnrSimilarFrameParam[2];
  double m_arnrQdecay;
  double m_arnrQdecayNoiseThr;
  int pass_spliter;
#if IQE
  int32_t m_dnrLevel;
  int32_t m_dnrFrame;
  float m_sharpRatio;
  int32_t m_cdefLevel;
#endif
  int32_t m_ltr2passth;
  /* used for roi ratecontrol */
  double m_fRoiBitrateRatio;
  char *m_pchQuantPath;  // please alloc by strdup and it will be released by t265_param_free
  void *m_pAnalysis;
  int32_t m_iAlignKeyint;
  int m_interpMeLowPrecision;
  double m_pboffset_weights;
} ten265_param_t;

typedef void ten265_t;

// ===============================================================================================
// Interface Function
// ===============================================================================================

/* ten265_get_version
 *  get ten265 encoder version
 */
const char *ten265_version(void);

/* ten265_param_alloc:
 *  Allocates an ten265_param_t instance. The returned param structure is not
 *  special in any way, but using this method together with ten265_param_free()
 *  and ten265_param_parse() to set values by name allows the application to treat
 *  ten265_param_t as an opaque data struct for version safety */
ten265_param_t *ten265_param_alloc(void);

/* ten265_param_free:
 *  Use ten265_param_free() to release storage for an ten265_param_t instance
 *  allocated by ten265_param_alloc() */
void ten265_param_free(ten265_param_t *param);

/* ten265_param_default:
 *      fill ten265_param_t with default values*/
void ten265_param_default(ten265_param_t *param);

/* ten265_param_parse:
 *  set one parameter by name.
 *  returns 0 on success, or returns one of the following errors.
 *  note: BAD_VALUE occurs only if it can't even parse the value,
 *  numerical range is not checked until ten265_encoder_open().
 *  value=nullptr means "true" for boolean options, but is a BAD_VALUE for non-booleans. */
uint32_t ten265_param_parse(ten265_param_t *param, const char *name, const char *value);

/* ten265_param_config_preset:
 *      fill ten265_param_t with default values from preset*/
int ten265_param_config_preset(ten265_param_t *param);

/* ten265_encoder_open:
 *      create a new encoder handler*/
ten265_t *ten265_encoder_open(ten265_param_t *param, void **ext_para, float vquality, const char * config);

/* ten265_encoder_encode:
 *      put the inpic into the encoder, get the outpic from the encoder, return the num of outpic */
int32_t ten265_encoder_encode(ten265_t *handle, ten265_inpic_t *inpic,
                                          ten265_outpic_t *outpic, void **ext_para);

/* ten265_encoder_close:
 *      close an encoder handler */
int32_t ten265_encoder_close(ten265_t *handle, void **ext_para);

/* ten265_encoder_header:
    return the VPS, SPS and PPS size that will be used for the whole stream.*/
int32_t ten265_encoder_header(ten265_t *handle, ten265_nal_t **pp_nal, int32_t *nnal);

/* ten265_encoder_reconfig:
    return < 0 reconfig failed
    return 1   reconfig in progress
    return 0   reconfig ok */
int32_t ten265_encoder_reconfig(ten265_t *handle, ten265_param_t *reconfiged_param);

#ifdef __cplusplus
}
#endif

/************************************************************************************************************************************************/
//for filter
// 32bit

typedef struct UnsharpData {
    int size;
    float amount;
    float ratio;
    uint8_t       *dst;
    const uint8_t *src;
    int dst_stride;
    int src_stride;
    int width;
    int height;
    uint32_t *sr;
    uint32_t **sc;
    void * extra;
} UnsharpData;

enum TEN_FILTER_TYPE {
    // model type
    TEN_FILTER_AF = 0x01, // artifact-reduction
    TEN_FILTER_SR = 0x04, // super resolution
    TEN_FILTER_SP = 0x08, // sharpening
    TEN_FILTER_AF_CFY = 0x10, // artifact classify
    TEN_FILTER_FACE_DETECT = 0x40,  //face detect
    TEN_FILTER_ASSESSMENT = 0x80,  //assessment

    TEN_FILTER_ALITEST = 0x100,  //ali test

    // sp mode
    TEN_FILTER_SP_MODE_WEAK = 0x1000,
    TEN_FILTER_SP_MODE_STRONG = 0x2000,

    // af mode
    TEN_FILTER_AF_MODE_AUTO = 0x010000,
    TEN_FILTER_AF_MODE_WEAK = 0x020000,
    TEN_FILTER_AF_MODE_STRONG = 0x040000,
    TEN_FILTER_AF_MODE_AVERAGE = 0x080000,

    // sr mode
    TEN_FILTER_SR_MODE_X2 = 0x100000,
    TEN_FILTER_SR_MODE_X3 = 0x200000,

    // log level
    TEN_LOG_INFO = 0x10000000,
    TEN_LOG_WARNING = 0x20000000,
    TEN_LOG_ERROR = 0x40000000,
    TEN_LOG_INTERNAL_ERROR = 0x80000000,
};

typedef struct {
    // face detect
    int face_protect_enable;
    float face_af_ratio;
    float face_sp_ratio;
    float global_sp_ratio;
    /*
     * reserve_param_int[0] for switch of face_landmark
     *
     * */
    int reserve_param_int[50];

    /*
     * reserve_param_float[0] for global_af_ratio
     * */
    float reserve_param_float[50];
} TENParam;

typedef struct{
        int left;
        int top;
        int width;
        int height;
}TenKeyBbox;

typedef struct {
    int x,y,w,h;
    float confidence;
    int keypoints[196]; //98 keypoints of facelandmarks
    int flag_keypoints; //if the face did face alignment or not
    TenKeyBbox keypoints_bbox[4]; //bounding box of left_eye_eyebrow, right_eye_eyebrow, nose, mouth
} TENFaceRect;

#ifdef __cplusplus
extern "C" {
#endif

    int unsharp_slice(UnsharpData *ud);
    int initTenParam(TENParam *ten_param);
    int initTEN(int h, int w, int filter_type, char* model_info_dir, void* param, int device_id, int *ctx_id);
    int executeTEN(unsigned char* input_buf, int input_h, int input_w, int input_c, unsigned char* output_buf, int out_size, int ctx_id);
    int uinitTEN(int ctx_id);
    /**
     * @brief add preprocess module into sdk
     * 
     * @param ext_para[in] sdk lincense auth handler
     * @param opts[in] opts string
     * @return int 
     */
    int add_preprocess(void **ext_para, char *opts);
#ifdef __cplusplus
    }
#endif
/************************************************************************************************************************************************/
//for ten tenav1
#ifdef __cplusplus
extern "C" {
#endif

#define TEN_AV1_LOG_NONE (-1)
#define TEN_AV1_LOG_ERROR 0
#define TEN_AV1_LOG_WARNING 1
#define TEN_AV1_LOG_INFO 2
#define TEN_AV1_LOG_DEBUG 3

// RC
#define PRINT_STATS 0

#define TEN_AV1_FOURCC 0x31305641

/* error code */
#define RET_ERROR_PARAM 1 /* param error */

/* Image data pointers. */
#define TEN_AV1_PLANE_Y 0 /**< Y (Luminance) plane */
#define TEN_AV1_PLANE_U 1 /**< U (Chroma) plane */
#define TEN_AV1_PLANE_V 2 /**< V (Chroma) plane */

/* preset */
#define TEN_BEST -1      /*150: 1*/
#define TEN_PLACEBO 0    /*100 : 1*/
#define TEN_VERYSLOW 1   /*50 : 1*/
#define TEN_SLOWER 2     /*30 : 1*/
#define TEN_TEN_SLOW 3       /*20 : 1*/
#define TEN_UNIVERSAL 4  /* 15 : 1*/
#define TEN_MEDIUM 5     /* 12 : 1*/
#define TEN_FAST 6       /* 10 : 1*/
#define TEN_FASTER 7     /* 10 : 1*/
#define vVERYFAST 8   /* 8 : 1*/
#define TEN_SUPERFAST 9  /* 5 : 1*/
#define TEN_ULTRAFAST 10 /* 5 : 1*/
#define TEN_HYPERFAST 11 /* 2 : 1*/

/* Range of QMS is between first and last value, with offset applied to inter blocks*/
#define TEN_DEFAULT_QM_Y 10
#define TEN_DEFAULT_QM_U 11
#define TEN_DEFAULT_QM_V 12
#define TEN_DEFAULT_QM_FIRST 5
#define TEN_DEFAULT_QM_LAST 9
#define TEN_MAX_MESH_STEP 4

#define TEN_MAX_OBU_NUM 32 /* maximum number of nal in tenav1_outpic_t */

#define TEN_MINQ 0
#define TEN_MAXQ 255
typedef enum tenav1_mode_t {
  // Good Quality Fast Encoding. The encoder balances quality with the amount of
  // time it takes to encode the output. Speed setting controls how fast.
    TEN_GOOD,
  // Realtime Fast Encoding. Will force some restrictions on bitrate constraints.
    TEN_REALTIME
} tenav1_mode_t;

typedef enum ten_timing_info { TEN_AV1_TIMING_UNSPECIFIED = 0, TEN_AV1_TIMING_EQUAL = 1, TEN_AV1_TIMING_DEC_MODEL = 2 } tenav1_timing_info;
typedef enum tenav1_aq_mode_t {
    TEN_NO_AQ = 0,
    TEN_VARIANCE_AQ = 1,
    TEN_COMPLEXITY_AQ = 2,
    TEN_CYCLIC_REFRESH_AQ = 3,
    TEN_AQ_MODE_COUNT  // This should always be the last member of the enum
} tenav1_aq_mode_t;

typedef enum tenav1_delta_q_mode_t {
  TEN_AV1_AQ_NONE = 0,
  TEN_AV1_AQ_VARIANCE = 1,
  TEN_AV1_AQ_AUTO_VARIANCE = 2,
  TEN_AV1_AQ_AUTO_VARIANCE_BIASED = 3,
  TEN_AV1_AQ_VARIANCE_OPT = 4,  // use tenav1 rate model to calculate Qindex offset.
  TEN_AV1_AQ_PERCEPTUAL = 5,    // Modulation to improve perceptual quality
  TEN_AV1_AQ_NUM                // This should always be the last member of the enum
} tenav1_delta_q_mode_t;

/*!\brief List of supported color primaries */
typedef enum tenav1_color_primaries_t {
  TEN_AV1_CICP_CP_RESERVED_0 = 0,   /**< For future use */
  TEN_AV1_CICP_CP_BT_709 = 1,       /**< BT.709 */
  TEN_AV1_CICP_CP_UNSPECIFIED = 2,  /**< Unspecified */
  TEN_AV1_CICP_CP_RESERVED_3 = 3,   /**< For future use */
  TEN_AV1_CICP_CP_BT_470_M = 4,     /**< BT.470 System M (historical) */
  TEN_AV1_CICP_CP_BT_470_B_G = 5,   /**< BT.470 System B, G (historical) */
  TEN_AV1_CICP_CP_BT_601 = 6,       /**< BT.601 */
  TEN_AV1_CICP_CP_SMPTE_240 = 7,    /**< SMPTE 240 */
  TEN_AV1_CICP_CP_GENERIC_FILM = 8, /**< Generic film (color filters using illuminant C) */
  TEN_AV1_CICP_CP_BT_2020 = 9,      /**< BT.2020, BT.2100 */
  TEN_AV1_CICP_CP_XYZ = 10,         /**< SMPTE 428 (CIE 1921 XYZ) */
  TEN_AV1_CICP_CP_SMPTE_431 = 11,   /**< SMPTE RP 431-2 */
  TEN_AV1_CICP_CP_SMPTE_432 = 12,   /**< SMPTE EG 432-1  */
  TEN_AV1_CICP_CP_RESERVED_13 = 13, /**< For future use (values 13 - 21)  */
  TEN_AV1_CICP_CP_EBU_3213 = 22,    /**< EBU Tech. 3213-E  */
  TEN_AV1_CICP_CP_RESERVED_23 = 23  /**< For future use (values 23 - 255)  */
} tenav1_color_primaries_t;        /**< alias for enum tenav1_color_primaries */

/*!\brief List of supported transfer functions */
typedef enum tenav1_transfer_characteristics_t {
  TEN_AV1_CICP_TC_RESERVED_0 = 0,      /**< For future use */
  TEN_AV1_CICP_TC_BT_709 = 1,          /**< BT.709 */
  TEN_AV1_CICP_TC_UNSPECIFIED = 2,     /**< Unspecified */
  TEN_AV1_CICP_TC_RESERVED_3 = 3,      /**< For future use */
  TEN_AV1_CICP_TC_BT_470_M = 4,        /**< BT.470 System M (historical)  */
  TEN_AV1_CICP_TC_BT_470_B_G = 5,      /**< BT.470 System B, G (historical) */
  TEN_AV1_CICP_TC_BT_601 = 6,          /**< BT.601 */
  TEN_AV1_CICP_TC_SMPTE_240 = 7,       /**< SMPTE 240 M */
  TEN_AV1_CICP_TC_LINEAR = 8,          /**< Linear */
  TEN_AV1_CICP_TC_LOG_100 = 9,         /**< Logarithmic (100 : 1 range) */
  TEN_AV1_CICP_TC_LOG_100_SQRT10 = 10, /**< Logarithmic (100 * Sqrt(10) : 1 range) */
  TEN_AV1_CICP_TC_IEC_61966 = 11,      /**< IEC 61966-2-4 */
  TEN_AV1_CICP_TC_BT_1361 = 12,        /**< BT.1361 */
  TEN_AV1_CICP_TC_SRGB = 13,           /**< sRGB or sYCC*/
  TEN_AV1_CICP_TC_BT_2020_10_BIT = 14, /**< BT.2020 10-bit systems */
  TEN_AV1_CICP_TC_BT_2020_12_BIT = 15, /**< BT.2020 12-bit systems */
  TEN_AV1_CICP_TC_SMPTE_2084 = 16,     /**< SMPTE ST 2084, ITU BT.2100 PQ */
  TEN_AV1_CICP_TC_SMPTE_428 = 17,      /**< SMPTE ST 428 */
  TEN_AV1_CICP_TC_HLG = 18,            /**< BT.2100 HLG, ARIB STD-B67 */
  TEN_AV1_CICP_TC_RESERVED_19 = 19     /**< For future use (values 19-255) */
} tenav1_transfer_characteristics_t;  /**< alias for enum tenav1_transfer_function */

/*!\brief List of supported matrix coefficients */
typedef enum tenav1_matrix_coefficients_t {
  TEN_AV1_CICP_MC_IDENTITY = 0,     /**< Identity matrix */
  TEN_AV1_CICP_MC_BT_709 = 1,       /**< BT.709 */
  TEN_AV1_CICP_MC_UNSPECIFIED = 2,  /**< Unspecified */
  TEN_AV1_CICP_MC_RESERVED_3 = 3,   /**< For future use */
  TEN_AV1_CICP_MC_FCC = 4,          /**< US FCC 73.628 */
  TEN_AV1_CICP_MC_BT_470_B_G = 5,   /**< BT.470 System B, G (historical) */
  TEN_AV1_CICP_MC_BT_601 = 6,       /**< BT.601 */
  TEN_AV1_CICP_MC_SMPTE_240 = 7,    /**< SMPTE 240 M */
  TEN_AV1_CICP_MC_SMPTE_YCGCO = 8,  /**< YCgCo */
  TEN_AV1_CICP_MC_BT_2020_NCL = 9,  /**< BT.2020 non-constant luminance, BT.2100 YCbCr  */
  TEN_AV1_CICP_MC_BT_2020_CL = 10,  /**< BT.2020 constant luminance */
  TEN_AV1_CICP_MC_SMPTE_2085 = 11,  /**< SMPTE ST 2085 YDzDx */
  TEN_AV1_CICP_MC_CHROMAT_NCL = 12, /**< Chromaticity-derived non-constant luminance */
  TEN_AV1_CICP_MC_CHROMAT_CL = 13,  /**< Chromaticity-derived constant luminance */
  TEN_AV1_CICP_MC_ICTCP = 14,       /**< BT.2100 ICtCp */
  TEN_AV1_CICP_MC_RESERVED_15 = 15  /**< For future use (values 15-255)  */
} tenav1_matrix_coefficients_t;

/*!\brief List of chroma sample positions */
typedef enum tenav1_chroma_sample_position_t {
  TEN_AV1_CSP_UNKNOWN = 0,          /**< Unknown */
  TEN_AV1_CSP_VERTICAL = 1,         /**< Horizontally co-located with luma(0, 0)*/
                                /**< sample, between two vertical samples */
  TEN_AV1_CSP_COLOCATED = 2,        /**< Co-located with luma(0, 0) sample */
  TEN_AV1_CSP_RESERVED = 3          /**< Reserved value */
} tenav1_chroma_sample_position_t; /**< alias for enum tenav1_transfer_function */

/*!\brief OBU types. */
typedef enum TenObuType {
    TEN_OBU_SEQUENCE_HEADER = 1,
    TEN_OBU_TEMPORAL_DELIMITER = 2,
    TEN_OBU_FRAME_HEADER = 3,
    TEN_OBU_TILE_GROUP = 4,
    TEN_OBU_METADATA = 5,
    TEN_OBU_FRAME = 6,
    TEN_OBU_REDUNDANT_FRAME_HEADER = 7,
    TEN_OBU_TILE_LIST = 8,
    TEN_OBU_VTEN_AV1_COPY_RIGHT = 9,  // reserve obu.
    TEN_OBU_PADDING = 15,
    TEN_OBU_COUNT
} TenObuType;

/*!\brief Rate control mode */
typedef enum tenav1_rc_mode {
  TEN_AV1_ABR, /**< Average Bit Rate (ABR) mode */
  TEN_AV1_CRF, /**< Constant Rate Factor (CRF) mode */
  TEN_AV1_Q,   /**< Constant Quality (Q) mode */
  TEN_AOM_VBR
} tenav1_rc_mode;

typedef enum tenav1_color_format_t {
    TEN_k400 = 0, /* Y */
    TEN_k420 = 1, /* YUV420 */
    TEN_k422 = 2, /* YUV422 */
    TEN_k444 = 3  /* YUV444 */
} tenav1_color_format_t;

enum TenFrameType {
    TEN_AUTO_FRAME = -1,
    TEN_KEY_FRAME = 0,
    TEN_INTER_FRAME = 1,
    TEN_INTRA_ONLY_FRAME = 2,  // replaces intra-only
    TEN_S_FRAME = 3,
    TEN_FRAME_TYPES,
};

/**\brief Image Descriptor */
typedef struct tenav1_inpic_t {
  unsigned int width;  /**< image width */
  unsigned int height; /**< image height */
  void *planes[3];     /**< pointer to the top left pixel for each plane */
  int stride[3];       /**< stride between rows for each plane */
  int64_t i_pts;       /**< input pts */
  int32_t i_type;      /**< input frame type */
  int *quant_offsets;  // quant_offsets of the 16x16 blocks in the pic
} tenav1_inpic_t;

typedef struct tenav1_timing_info_t {
  uint32_t num_units_in_display_tick;
  uint32_t time_scale;
  int equal_picture_interval;
  uint32_t num_ticks_per_picture;
} tenav1_timing_info_t;

typedef struct tenav1_dec_model_info_t {
  uint32_t num_units_in_decoding_tick;
  int encoder_decoder_buffer_delay_length;
  int buffer_removal_time_length;
  int frame_presentation_time_length;
} tenav1_dec_model_info_t;

typedef struct TEN_MESH_PATTERN {
  int range;
  int interval;
} TEN_MESH_PATTERN;

/*!\brief Encoder output packet
 *
 * This structure contains the output data the encoder produce while compressing a frame.
 */
typedef struct tenav1_packet_t {
  uint8_t i_key_frame;
  int64_t i_pts;
  int32_t i_type;
  uint8_t *payload;   /**< compressed data buffer */
  uint64_t i_payload; /**< length of compressed data */
} tenav1_packet_t;

typedef struct tenav1_output_t {
  uint8_t i_key_frame;
  int64_t i_total_size;
  int64_t i_pts;
  int64_t i_dts;
  int32_t i_nal;
  double psnr[3];
  double ssim[3];
  tenav1_packet_t nal[TEN_MAX_OBU_NUM];
} tenav1_output_t;

/*!\brief Rational Number
 *
 * This structure holds a fractional value.
 */
typedef struct tenav1_rational_t {
  int num;        /**< fraction numerator */
  int den;        /**< fraction denominator */
} tenav1_rational_t; /**< alias for struct tenav1_rational */

/*!\brief Encoder configuration structure
 *
 * This structure contains the encoder settings that have common representations
 * across all codecs. This doesn't imply that all codecs support all features,
 * however.
 */
typedef struct tenav1_param_t {
  // file
  char *input;
  char *bitstream;
  char *recon_file;
  char *twopass_path;
  int stat_keep;

  // high encode feature
  char tune[20];
  int preset;
  int profile;
  int level_idx_0;  // TODO: remove
  int write_webm_muxer;
  int write_ivf_muxer;
  tenav1_rational_t fps;
  tenav1_rational_t timebase;  // stream timebase units
  int force_vfr_test;
  int enable_monochrome;  // yuv400
  int force_consistency;
  int bit_depth;           // input yuv bitdepth
  int internal_bit_depth;  // internal bit depth for encoding
  int read_buf_cnt;

  // log info
  int log_psnr;
  int log_ssim;
  int log_level;
  void (*pf_log)(void *, int i_level, const char *psz, va_list);
  void *p_log_private;

  // size and position
  int width;               // width of the frame
  int height;              // height of the frame
  int frames_to_encoded;   // max number of frames to encode
  int drop_frames;         // skip the first n frames
  int enable_super_block;  // 1:enable 128x128 CTU; 2: condition from width/height; 3: further condition from frame-thread
  int min_partition_size;  // min partition size [4,8,16,32,64,128]
  int max_partition_size;  // max partition size [4,8,16,32,64,128]
  int uniform_spacing;     // devide tile in uniform way.
  int tile_rows;
  int tile_cols;

  // sei
  int write_copyright;

  // lookahead
  int lag_in_frames;
  int lookahead_delay;
  int enable_lookahead_delay;
  int lookahead_block_size;    // TODO: remove
  int lookahead_pool_threads;  // TODO: remove
  int lookahead_slices;        // only default
  int lookahead_parallel;
  int lookahead_hmvp_thresh;    // only default
  int lookahead_search_method;  // only default
  int lookahead_satd_scale;
  int lookahead_satd_scale_mvp;
  int lookahead_satd_scale_thres1;
  int lookahead_satd_scale_thres2;
  int lookahead_skip_fracme;
  int lookahead_search_range_shift;  // only default
  int lookahead_early_skip;          // only default
  int lookahead_early_skip_intra;
  int lookahead_early_skip_intra1;
  int lookahead_early_skip_intra2;
  int vfr_input;
  int align_input_type;  // align with source picture type, 0: closed, 1 : align with I frame, 2 : align with I / P frame default

  // aq_mode
  int aq_mode;
  double aq_strength;   // only default
  double aq_weightmax;  // TODO: enc_cu
  double aq_weightmin;  // TODO: enc_cu

  // cu_tree
  int cutree;
  int dramatic_scene_cutree_reset;
  double cutree_strength;

  // tpl model
  int enable_tpl_model;
  int tpl_me_method;
  int tpl_length;
  double tpl_length_thres;
  double quant_ratio_strength;
  double tpl_scaling_factor;
  int adapt_weight_in_tpl;
  int tpl_adapt_weight_default;
  double tpl_adaptweight_coeff1;
  double tpl_adaptweight_coeff2;
  double tpl_kf_strength;
  int tpl_lowres_weight;
  int tpl_base_size;
  int tpl_me_size;
  int tpl_4k_me_size;
  int tpl_scale_thres;
  int align_rps_in_tpl;
  int tpl_similar_mvp_thr;
  int tpl_max_mvp_num;
  int tpl_prune_mvp_thr;
  int tpl_prune_ref_mvp_thr;
  int tpl_reorder_ref_frames;
  int tpl_cplx_block_thr;
  int tpl_sse_shift;
  double tpl_deltaq_strength;
  int tpl_interp_taps;
  int tpl_adapt_length;
  int tpl_fast_intra;
  int tpl_intra_edge_filter;
  int tpl_nstep_delta;
  int tpl_cost_sad;

  // arnr
  int arnr_max_frames;
  int arnr_interp_taps;  // TODO: function
  int arnr_me_method;
  int arnr_prune_mvp_thr;
  int arnr_similar_mvp_thr;
  int arnr_prune_16x16_thr;
  int arnr_prune_simple_block;
  int arnr_prune_by_block_color;
  int arnr_strength;
  double arnr_q_decay;
  int filter_second_arf;
  int adapt_arnr_frames;
  int similarity_based_arnr;
  int filter_sec_skip_thres;
  int arnr_parallel_rows;
  double arnr_ref_frame_size;
  double arnr_decays_param[3];
  double arnr_window_error_ratio;
  double arnr_d_factor_min;
  double arnr_similar_frame_param[2];

  // feature
  int zero_latancy;  // only default
  int high_quality_iframe;
  int adaptive_overlay;

  // scene cut
  int enable_scenecut;
  int scenecut_threshold;
  int scenecut_bias;  // only default
  int scenecut_propagate_thr;
  int scenecut_end_seqs;
  int scenecut_filter;     // only default
  int detect_black_white;  // only default
  int detect_transition_to_still;
  int end_judgement;
  double vbv_end_ratio;

  // screen content detection
  int screen_content_detect_opt;

  // gop
  int gop_structure; /* 0(random-access) 1(low-delay) 2(all-intra) */
  int gop_size;
  int adaptive_gop; /* 0(none), 1(fast), 2(trellis?)*/
  int open_gop;
  int keyint_min;  // keyframe minimum interval
  int keyint;      // keyframe maximum interval
  int round_keyint;
  int key_fps_period;
  int still_picture;           // full_still_picture_hdr
  int full_still_picture_hdr;  // full_still_picture_hdr
  // for adapt gop
  int gpb_large_mv_thresh[4];  // threshold for gop 8, 16, 32
  int large_mv_frac_thresh[4];
  int intra_frac_thresh[4];
  int cost_ratio_thresh[4];
  int adapt_cost_ratio0;
  int adapt_cost_ratio1;
  int adapt_diff_ratio;
  int adapt_simple_ratio;
  int adapt_matched_block_propotion;
  int adapt_cplx_block_propotion;
  int gdb_zero_mv_thresh;

  // rate control
  enum tenav1_rc_mode rc_mode;
  int cq_level;  // constrained quality level
  int enable_roi;
  double roi_strength;
  int qp;
  int crf2qp;  // 1:crf2qp to match 265 bitrate, 2:crf2qp to match all qindex(0:255) by linear model
  int stat_write;
  int stat_read;
  int delta_bigq;
  int use_lambda_tab;
  int qpindex_min;
  int deltaq_mode;
  int use_aom_qp_offset;
  int adapt_pb_boost;
  int overflowed_gf_qplevel;
  double overflowed_gf_gap;
  double overflowed_gf_coeff;
  int max_pb_boost;
  int min_pb_boost;
  int ori_weight;
  int new_weight;
  int pb_boost_coeff;
  double lambda_scale_max[2];
  double lambda_scale_min;
  int cu_level_lambda_strength;
  double vmaf_lambda_coeffs[4];  // 0: u, 1: b, 2: k, 3: o.
  int worst_allowed_q;
  int best_allowed_q;
  int rc_min_quantizer;  // min quantizer (best quality)
  int rc_max_quantizer;  // max quantizer (worst quality)
  uint32_t target_bitrate;
  uint32_t vbv_buffer_size;
  uint32_t vbv_maxrate;
  uint8_t is_abraddvbv;
  double vbv_buffer_size_period;
  uint8_t row_level_rc;
  int8_t b_icompen_window;
  double ratio_pred;
  int vbv_clip;
  int qp_step;
  double rc_q_compress;
  double vbv_pred_weight[3];
  double vbv_pred_min_weight[3];
  double complex_scene_thres;
  double vbv_init;
  double vbv_buffer_end;
  double vbv_end_frame_adjust;
  int enable_const_vbv;
  double crf;
  int input_crf;
  double crf_constant_max;
  double crf_constant_min;
  double qcompress;
  double ipratio;
  double pbratio;
  double qp2qstep_power;
  double qp2qstep_base;
  int mbtree_offset;
  int thread_lock;
  double keep_scene_scale;
  int qpres_qthres;
  double overflow_max;
  double overflow_min;
  int adjust_lamda_use_tpl[2];
  double ctu_lamda_max[2];
  double ctu_lamda_min[2];
  double adjust_lamda_noise_level;
  double curve_adjust_lambda_base_ratio[2];
  int worst_quality_calc_iters;  // worst quality calculation iters for cqp_vbv before encode, 0 is close
  int log_rctrace;
  double limit_abnormal_ssim_lamda_factor[2];
  int adjust_lamda_block_min_num;
  double lamda_factor_same_direct_ratio;
  int diff_adjust_direct_num[3];
  double cplxr_sum_factor[4];
  double cplxr_sum_factor_static;
  double cplxr_cost_ratio_thres;
  double cplxr_dark_ratio_thres;
  int rc_sync_dist;
  int abr_init_length;  // set gop=16 for abr init
  int abr_init_gop;
  double common_dark_ratio_thres;
  int dark_clip_qindex;
  int adaptive_vbv;  // 0: close, 1:only overflow, 2: overflow and underflow for simple, 3: overflow and underflow
  double adaptive_vbv_weight;
  double adaptive_vbv_weight_simple;

  // rd opt for aom rate control mode
  int use_neighbor_qp;
  double arf_boost_factor;
  int gfu_boost_thresh;  // lambda rd opt
  int lambda_offset;     // lambda rd opt
  int adaptive_qplevel;
  int shorten_gpgap_offset;
  double adaptive_qp_darksce_thres;
  int qpoffset_limit;
  int qpoffset_limit_low;
  int adaptqscale_satd_thres[3];
  int adapt_qplevel_postive_th;
  int adapt_qplevel_uvsatd;
  int flat_qplevel_for_arf;
  int last_gop_qp_offset;
  int adaptive_lambda_level;
  int enable_1to4_lamda;
  int adaptive_vmaf_size;
  int adaptive_vmaf_interintra;
  int tune_ssim_lambda;
  int tune_vmaf_lambda;
  double lamda_b32_max;
  double tpl_ctu_lamda_max;
  double tpl_ctu_lamda_min;
  double tpl_lamda_pow;
  double tpl_factor_large_diff_min;
  double tpl_factor_large_diff_max;
  double tpl_ctu_factor_diff_max;
  int qp_float_compensation;
  int tpl_ctu_offset_base_frame_layer;
  double tpl_qindex_offset_pow[7];
  int ctu_qindex_max_diff;
  double ctu_lamda_qindex_weight;
  double ctu_lamda_qindex_weight2;
  double ctu_lamda_qindex_weight3;
  // rd opt for v265 rate control mode
  int adaptive_qscale;
  int first_i_inter_thres;
  double first_i_intra_thres;
  int first_i_clip0;
  int adaptive_ipratio;
  int adaptive_pbratio;
  double ratio_thres;
  double min_qscale;
  double max_qscale;
  double max_pbratio;
  double gpb_scale_ratio_thres_min;
  int gpb_scale_inter_thres_min;
  int gpb_scale_inter_thres_max;
  int gpb_scale_intra_thres;
  double gpb_scale_ratio;
  int adaptive_complexity;
  int use_aom_gopqp;

  // filter (deblock cdef restoration)
  int enable_ctu_filter;
  int enable_ctu_filter_layers;
  int filter_param_delay;
  int faster_deblock_search;
  int enable_deblock;
  int enable_cdef;
  int enable_restoration;
  int deblock_pick_method;
  int deblock_pick_dual;  // 0 : only separate. 1 : only dual. 2 : both
  int deblock_step_thres;
  int cdef_pick_method;
  int nb_cdef_strengths_used;
  int uv_dc_delta_q;
  double cdef_lambda_factor;
  int uv_ac_delta_q;
  int cdef_arg1;
  int cdef_arg2;
  int restoration_pick_method;
  int interlace_restoration;
  int enable_lr_uv_shift;
  int enable_lr_maxsize_limit;
  int prune_wiener_based_on_src_var;  // 0 : no pruning 1 : conservative pruning 2 : aggressive pruning
  int enable_sgr_ep_pruning;
  int prune_sgr_based_on_wiener;
  int closed_restoration_type;
  int disable_finerwiener;
  int close_chroma_rest;
  double cdef_sse_factor;
  double rest_sse_factor;
  int delta_q_res_factor;
  int enable_tpl_frame_qp;
  double tpl_frame_qp_i_offset;
  double tpl_frame_qp_p_offset;

  // frame multiple thread
  int frame_threads;
  int fpp_rows_delay;
  int extend_mv_limit;
  int limited_ref_layer;

  // wpp
  int wpp;  // enable row wpp analyse
  int row_ctx_method;
  int pool_threads;

  // tile parallel
  int tile_threads;

  // rdo
  // 0: no ctx update. 1: ctu; 2: cu; 3: tu ( Tu not supported yet.)
  int syntax_skip_layer;    // Specify which frame layer may skip cu level update.
  int syntax_update_freq;   // if syntex update in ctu level, config it for skipping some CTU.
  int syntax_update_level;  // Mode & Coeff cdf and cost update frequency  to enc_cu
  int update_ctu_ctx_freq;
  int mv_update_level;      // Mv cdf and cost update frequency
  int mv_update_range;      // Only update [-mv_update_range, mv_update_range] mv cost (Integer)
                            // When mv_update_level == CTX_UPDATE_CU.

  int rdoq_max_nz_nums;

  tenav1_color_primaries_t color_primaries;                    // TODO: sps
  tenav1_transfer_characteristics_t transfer_characteristics;  // TODO: sps
  tenav1_matrix_coefficients_t matrix_coefficients;            // TODO: sps
  tenav1_chroma_sample_position_t chroma_sample_position;      // TODO: sps ?
  int color_range;                                          // TODO: sps
  int timing_info_present;                                  // TODO: sps
  int timing_info_type;

  // rps
  int bframe_next_layer;
  int long_term;
  int max_reference_frames;    // enable reduced set of references
  int max_reference_frames_b;  // enable reduced set of references of normal B
  int adapt_reference_frames_b;
  int clean_reference_frames;  // reduce reference picture set
  int use_sec_rps;
  int layer_use_prev_gop;

  // to frame
  int allow_intra_layer;
  int interlace_sad_size;
  int interlacex4_sad_size;
  int enable_interlace_sad;
  int enable_me_interlace_sad;
  int using_qm;
  int qm_minlevel;
  int qm_maxlevel;
  int transform_mode; /* transform mode: 0(only 4x4) 1(largest) 2(select) */
  int enable_segment;
  int shorten_gpgap_weight;
  uint8_t cdf_update_mode;
  int enable_order_hint;
  int order_hint_bits;
  int enable_ref_frame_mvs;  // maximum number of references per frame
  int errorthres_skip_tmvp;
  int errorthres_skip_tmvp2;
  int skip_ref_frame_layer;

  int enable_global_motion;       // enable global motion usage for sequence
  int skip_thr_global_motion[3];  // skop global motion alg
  int enable_primary_ref;         // enable primary reference
  int use_lowres_feature_points;  // use lowres to detect feature points
  int enable_warped_motion;       // sequence level
  int enable_screen_content_tools;
  int reduced_tx_type_set;
  int enable_adapt_idtx;

  int reduce_global_motion;
  int hp_mv_qindex[2];
  int prune_ref_frame;
  int prune_ref_frame_for_rect_partitions;

  // in warped_motion
  int gm_inliers_thresh;
  int gm_improve_correspondence;
  int gm_skip_near_identity;
  int prune_gm_refs;
  int prune_gm_refinement;
  int gm_search_type;
  int selective_ref_gm;
  uint8_t gm_erroradv_type;

  // to enc_cu
  int enable_rect_partitions;  // enable rectangular partitions for sequence
  int enable_ab_partitions;    // enable AB partitions for sequence
  int enable_1to4_partitions;  // enable 1:4 and 4:1 partitions for sequence
  int enable_inter_obmc;
  int cu_order_check;  // 4:NONE_OTHER_SPLIT  0:NONE_SPLIT_OTHER 1:SPLIT_NONE_OTHER 2:ADAPT1 3: ADAPT2
  int cu_order_from_var;
  int skip_cur_from_maxsize;
  int neighbor_size_skip_full;
  int cu_topdown_from_tplmv;
  int stop_split_from_nbor_nsplit_cost[6];
  int stop_nrec_from_nbor_nsplit_cost[6];
  int stop_sub_from_nbor_nsplit_cost[6];
  int skip_128_qp_max;
  int skip_sub_from_minsize[6];
  int skip_horver_from_found;
  int skip_rect_partition_depth;
  int stop_sub_from_nbor_nsplit_count;
  int skip_ab4_from_rdcost[6];
  int skip_ab4_from_mixrd[6];
  int skip_ab_from_ml[6];
  int subdiff_skip_split_ratio[6];
  int subdiff_skip_rec_ratio[6];
  int subdiff_skip_split_nocoeff[6];
  int subdiff_skip_split_nocoeff_judge;
  int subdiff_skip_split_nocoeff_factor;
  int subcost_skipfull_thresh[6];
  int costdiff_skip_rec_thres[6];
  int skipver_fromhor_thresh[6];
  int subdiff_skip_ab4_thres[6];
  int subsplit_skip_full_thresh[6];
  int subpart_skip_other_thresh[6];
  int subsplit_skip_rec_thr[6];
  int subnone_skip_rec_thr[6];
  int subsplit_skip_ab4_thresh[6];
  int splitmode_skip_ab4_thres[6];
  int split_skip_hv4_thres[6];
  int subsplit_afterrec_skip_other;
  int skip_ab4_from_mixrd_depth;
  int skip_rect_with_ml[6];
  int prune_inter_from_skipmode[6];
  int prune_inter_from_nonskip[7];
  int prune_split_from_dist[6];
  int prune_split_fromdist_forframe;
  int precost_derive_dir[2];
  int precost_derive_size[6];
  int stop_sub_from_nbor_nsplit_weight;  // only for intra_skip_thr
  int inherit_skip_reference;            // only used in InitCu
  int inherit_skip_globalmv;             // only used in InitCu
  int inherit_skip_warp;                 // only used in InitCu
  int ref_mask_layer;
  int skip_cu_base_submv[6];
  int try_intra_before_inter;
  int intra_rect_layer_thr;
  int intra_rect4_layer_thr;
  int skip_palette_by_ref;
  int skip_hv4_by_grad[6];
  int skip_4x4_by_stats[7];
  int skip_8x8_by_stats[7];
  int skip_64x64_by_stats[7];
  int skip_128x128_by_stats[7];
  int skip_64_1to4_by_stats[7];
  int skip_32_1to4_by_stats[7];
  int prune_intramode_by_scc;
  int first_stage_split;
  int skip_intra_base_analysis[7];
  int skip_intra_base_best_nb[7];
  int skip_intra_from_comp_mode[6];
  // to rqt
  int prune_tx_search_level;  // TODO: to rqt
  uint8_t tx_prune_mode[6];
  int use_reduced_intra_txset;  // prune two least frequently chosen transforms for each intra mode
  int use_skip_flag_prediction[2];
  int ml_tx_split_thresh;  // Threshold used by the ML based method to predict TX block split decisions.
  int enable_flip_idtx;    // enable flip and identity transform types
  int use_intra_dct_only[2];
  int use_inter_dct_only;
  int luma_txsplit_skip[2];
  int luma_txsplit_inter[6];
  int luma_txsplit_intra[6];
  int inter_txtype_bestref_skip[4];
  int full_rec_skip_full_thresh[6];
  int subcu_skip_from_remain[6];
  int txtype_prune_qsort;
  int txtype_refrd_skip[3];
  int intra_txtype_bestref_skip[7];
  int luma_txdepth_skiptu;
  int fast_rdoq_thres[6];
  int inter_decision_tu_depth[6];
  int luma_intracost_skiptu;
  int calc_tuskip_thresh;
  int full_rd_use_rdoq;
  int fastrdoq_layer;
  int fastrqt_chroma;
  int rdoq_uv_mult[6];
  int rdoq_uv_mult_thr;
  int rdoq_uv_mult_qp;
  int disable_identical_txtype;
  int unit_trans_from_size;
  int enable_ml_tx_split;
  int txfm_type_skip_same_rd[6];
  int intra_txfm_type_yrd[9];
  int fst_inter_intra_txfm_type[8];  // check inter before check intra
  int fst_intra_inter_txfm_type[8];  // check intra before check inter

  // to enc_inter
  int lookahead_mesh_level;
  int encode_mesh_level;  // TODO: search
  int max_mesh_interval;
  int interp_level;
  uint8_t subpel_interp_taps;  // TODO: to enc_inter
  uint8_t subpel_adapt_interp;
  int cdef_skip_layer;
  int restoration_skip_layer;
  int prune_wedge_pred_diff_based;  // TODO: to enc_inter
  int search_method;                // Motion search method (Diamond, NSTEP, Hex, Big Diamond, Square, etc).
  int search_range[2];
  int subpel_iters_per_step[2];               // Maximum number of steps in logarithmic subpel search before giving up.
  uint8_t enable_sec_sub_search;              // enable me second  large mv subpel search
  uint8_t subpel_force_stop;                  // When to stop subpel search.
  uint8_t lookahead_subpel_force_stop;        // When to stop subpel search for tpl and arnr.
  uint8_t joint_search_size_thresh[2];        // TODO: to enc_inter
  uint8_t comp_inter_joint_search_thresh[7];  // TODO: to enc_inter
  int prune_intra_from_skip[7];
  int max_intra_bsize;                // TODO: to enc_inter
  int enable_dist_wtd_comp;           // enable dist wtd compound for sequence
  int enable_reduced_reference_set;   // sequence level
  int enable_masked_comp;             // enable masked compound for sequence
  int enable_onesided_comp;           // enable one sided compound for sequence
  int enable_interintra_comp;         // enable interintra compound for sequence
  int enable_diff_wtd_comp;           // enable diff-wtd compound usage
  int param_enable_interinter_wedge;  // enable interinter-wedge compound usage
  int param_enable_interintra_wedge;  // enable interintra-wedge compound usage
  int enable_mv_refine[6];
  int mv_refine_limit[6];
  int mv_refine_in_cu_layer;
  int enable_mode_threshold;
  int inter_search_order;
  int enable_single_merge;
  int corner_pel_count[2];
  int skip_fullrd_from_skip[6];
  int skip_intra_from_other_partition;
  int mesh_search_thresh;
  int try_inter_from_subintra;
  int skip_intra_dir_num[6];
  int adapt_me_method[3];
  int adapt_me_range[4];
  int start_mv_opt;
  int ref_mv_stack_cand_opt;
  int allow_exhaustive_searches;  // TODO: to enc_inter
  int fast_mesh_search;
  int get_inherit_data;
  int force_get_inherit_data;
  int get_inherit_num;
  int inter_fullrd_skip_same_dist;
  int tz_dia_skip_round;
  int tz_refine;
  int tz_scan_centre_change;
  int intrabc_rd_opt;
  int intrabc_remove_restriction;
  int ref_select_base_single_mode[6];  // 0 for close class,other for slice type
  int ref_use_nb_info;
  uint32_t ref_nblock_thr[6];
  uint32_t ref_simple_thr[6];
  int ref_mask_adjust;
  uint32_t ref_nblock_min;
  int ref_single_thr[6];
  uint32_t ref_newmv_thr[6];
  int ref_newmv_add_base_sad[6];
  int comp_mode_ref_limit[6];
  int comp_mode_ref_limit_estrd[6];
  int enable_fullrd;
  int fullrd_ref_ratio;
  int reduce_newmv_mvp_num[4];
  int handle_inter_newmv[6];
  int handle_inter_new_newmv;
  int fullrd_skip_rd_thr[7];
  int fullrd_pre_break_thr[7];  // before inter_txfm_search for rdo
  int skip_motionmode_after_simple[7];
  int skip_full_rd_thr[6];
  int skip_motionmode_base_refrd[6];
  int skip_comp_mode_thr[6];
  int skip_base_single_merge[6];
  int skip_comp_search_thr[6];
  int first_intra_ratio[6];
  int first_intra_ratio_palette[6];
  uint32_t only_intra_ratio[7];
  int only_inter_ratio[6];
  uint32_t inter_simple_intra[6];
  uint32_t sec_layer_skip_base_var[6];
  uint32_t fst_intra_skip_after_single_mrg[6];
  uint32_t fst_intra_skip_base_remain_rd[6];
  uint32_t fst_intra_skip_comp_search[6];
  uint32_t fst_intra_skip_comp_mode[7];
  uint32_t skip_interp_rd_single;
  uint32_t skip_intra_from_father_skip[6];
  uint32_t skip_interp_motionmode_rd[6];
  uint32_t skip_interp_motionmode_base_mv;
  uint32_t fst_intra_use_tpl;         // 0 use lookahead; other use tpl
  uint32_t fst_intra_use_qpfactor;    // 0 use lookahead; other use tpl
  uint32_t enable_inter_three_layer;  // 0 use two layer; other use three layer
  int qme_early_skip_thr[6];          // Quarter accuracy 1/4
  int eme_early_skip_thr[6];          // One-eighth accuracy  1/8
  int subme_point4_skip_thr[6];       // Subme refine threshold
  int mv_refine_skip_num[6];
  int mv_refine_skip_thr[7];;
  int mv_refine_n1_skip_thr[6];
  int skip_frac_me_encode;
  int skip_frac_me_arnr;
  int skip_frac_me_tpl;
  int adjust_intra_num[6];
  int adjust_intra_thr[6];
  int early_skip_intra_thr[7];
  int early_skip_single_mrg_thr[6];
  int early_skip_single_sr_thr[6];
  int newmv_ref_order_adjust[6];
  int skip_single_sr_ref_order[7];
  int single_merge_rdo[8];
  int reduce_sgl_mrg_rdo_thr[8];
  int me_correct[5];
  int first_rd_ratio;
  int first_rd_push_ratio;
  int second_rd_ratio;
  int second_rd_push_ratio[2];
  int sec_push_rd_thr[6];
  int sec_push_skip_comp_mode[6];
  int enable_10bit_fast_txfm;  // only work for 10bit
  int fullrd_txfm_max_num[6];
  int sgl_mrg_rdo_max_num[6];
  int secrd_txfm_max_num[6];
  int param_fast_obmc_search;  // 0: obmc_full_pixel_diamond 1~6: obmc_refining_search_sad (faster)
  int fast_sgl_mrg_rdo;
  int selective_ref_frame;
  int first_layer_comp_thr;
  int second_layer_comp_thr;
  int inter_intra_thr;
  int reduce_newmv_by_splitnone;
  int newmv_only_first_mvp;
  int first_layer_uv_ref_ratio;
  int skip_obmc_base_partition_bsize[10];  // 0 for enable, 1~6 for bsize, 7 for partition, 8 for mode, 9 for slice_depth
  int skip_warp_base_partition_bsize[10];  // 0 for enable, 1~6 for bsize, 7 for partition, 8 for mode, 9 for slice_depth
  // to enc_intra
  int enable_filter_intra;  // enable filter intra for sequence
  int enable_smooth_intra;  // enable smooth intra modes for sequence
  int enable_paeth_intra;   // enable Paeth intra mode for sequence
  int enable_cfl_intra;     // enable CFL uv intra mode for sequence
  int enable_palette;
  int enable_intrabc;
  int enable_intrabc_hash;
  int intrabc_mesh_range;
  int intrabc_mesh_interval;
  int enable_angle_delta;
  int inter_curvfit_rd_ratio;
  int intra_ydir_decision_tu_depth[6];
  int intra_coarse_precise_size[2];  // 0 intra  1 inter
  int intra_ymode_rd_num[7];         // 0 intra  1 inter
  int ymode_delta_angle_rd_thr[2];   // 0 intra  1 inter
  int intra_ymode_nb_thr[2];         // 0 intra  1 inter
  int intra_ymode_sec_rd_num[7];     // 0 intra  1-6 inter
  int intra_ymode_skip_thr[2];       // 0 intra  1 inter
  int intra_ymode_rd_thr[7];         // 0 intra  1 inter
  int intra_filter_rd_num[6];
  int intra_filter_rd_thr[6];
  int intra_skip_filter_thr[6];
  int intra_uvmode_angle_num[2];  // 0 intra  1 inter
  int intra_uvmode_angle_thr[2];  // 0 intra  1 inter
  int only_try_uv_dm_mode[2];     // 0 intra  1 inter
  int uvmode_skip_angle_thr[2];   // 0 intra  1 inter
  int intra_skip_thr[4];          // only for inter
  int intra_angle_fullrd_skip[7];
  int intra_ymode_angle_skip[7];
  int enable_inter_intra_palette_uv;
  int palette_est_thr[2];
  int palette_skip_param[2];
  int palette_num_reduce;
  uint32_t simple_intra_for_inter[6];
  uint32_t fst_intra_dc_fullrd;
  int intra_pruning_luma_with_hog;
  float intra_prune_luma_with_hog[7];
  float intra_prune_chroma_with_hog[7];
  int intra_pruning_chroma_with_hog;
  int skip_palette_from_minmax;
  int enable_intra_edge_filter;  // enable intra-edge filter for sequence
  int skip_palette_uv_base_y;
  int skip_palette_uv_base_yuv;
  int skip_palette_uv_for_yskip;
  int skip_palette_base_nb[7];
  int intra_ymode_base_toprd[7];  // 0~5 for slice,6 for num
  int skip_cfl_base_nb[2];
  int intra_use_4x4_nb;
  int intra_y_delta_skip_thr[6];
  int intra_y_delta_skip_base_currrd;
  int intra_y_main_skip_base_currrd;
  int intra_y_delta_skip_num[6];
  // to enc_cu to enc_inter
  int get_inherit_mode_ref;
  int enable_interp_switchable;
  int interp_rd_from_luma;
  int close_simple_scene_interp_rd;
  int close_single_interp_rd;
  int close_sharp_interp_rd;
  int sharp_var_thres;
  int prune_inter_8x8;
  int prune_single_merge;
  int prune_comp_merge;
  int prune_single_search;
  int prune_comp_search;
  int prune_comp_sr_mode;
  int skip_newmv_mc;
  int early_terminate_skip_mode;
  int boundary_mode;              // TODO: remove ?
  tenav1_timing_info_t timing_info;  // TODO: remove

  int rest_wiener_start_step;
  int gmv_corner_detect_sample;
  int zero_resi_skip_txfm;
  int wiener_use_window_reduced;

  // AOM RC cfg
  int64_t starting_buffer_level_ms;
  int64_t optimal_buffer_level_ms;
  int64_t maximum_buffer_size_ms;
  unsigned int max_intra_bitrate_pct;
  unsigned int max_inter_bitrate_pct;
  int under_shoot_pct;
  int over_shoot_pct;
  int vbrmin_section;
  int vbrmax_section;
  ///// GFConfig,gf_cfg
  double kf_boost_scale;
  double coded_error_scale;
  double coded_error_scale_low;
  double coded_error_scale_high;
  int boost_weight;

  int adaptive_boost_in_bit_allocation;  // optimize the weight of normal B frames in boost bits calculation
  int sliding_window_scale;              // the scale of sliding window in bits error correction, default is 1
  int adaptive_cqlevel_in_boost;         // use cq level calculated by model and target bits to compute boost in preanalysis
  int align_aom_coded_error;             // whether to align aom coded error or satd
  double avg_satd_scale;                 // scale of avg satd used in active worst quality computation
  double intra_skip_pct_scale;           // align intra skip pcnt
  int use_dc_pct_in_coded_error;
  double adj_r_in_awq_with_boost;   // scale target bits in calculating active worst quality with boost
  int put_forward_tpl_calculation;  // put forward tpl calculation
  int inter_skip_thresh;
  int adjust_worst_quality_with_boost;  // adjust worst quality calculation with boost for GOP of kf
  int add_vbv_aom;
  int use_boost_bre_opt;                 // bite qingxie
  int limit_left_bandwidth;              // limit the adjustment of left bandwidth
  int adj_worst_quality_255;             // adjust intl arf worst quality when GOP worst quality =255
  int adj_frame_worst_quality_overflow;  // adjust frame worst quality when equals to best quality and overflow
  int move_forward_q_update;             // move forward q update
  int open_opt_vbr1190;                  // close above 4 opt
} tenav1_param_t;

typedef void tenav1_t;

void tenav1_param_default(tenav1_param_t *param);
#define TEN_AV1_PARAM_BAD_NAME (-1)
#define TEN_AV1_PARAM_BAD_VALUE (-2)
int tenav1_param_parse(tenav1_param_t *param, const char *name, const char *value);
int tenav1_param_config_preset(tenav1_param_t *param);
tenav1_t *tenav1_encoder_open(tenav1_param_t *para, void ** extra, const char * config);
int32_t tenav1_encoder_encode(tenav1_t *h, const tenav1_inpic_t *inpic,
        tenav1_output_t *outpic, void ** extra);
void tenav1_encoder_close(tenav1_t *h, void **ext_para);
const char *tenav1_version(void);

#ifdef __cplusplus
}
#endif
/************************************************************************************************************************************************/
//ten264 codec

#ifdef __cplusplus
extern "C" {
#endif

#include <stdarg.h>
typedef struct ten264_t ten264_t;

/****************************************************************************
 * NAL structure and functions
 ****************************************************************************/
typedef struct ten264_nal_t
{
    int i_ref_idc;  /* nal_priority_e */
    int i_type;     /* nal_unit_type_e */
    int b_long_startcode;
    int i_first_mb; /* If this NAL is a slice, the index of the first MB in the slice. */
    int i_last_mb;  /* If this NAL is a slice, the index of the last MB in the slice. */

    /* Size of payload (including any padding) in bytes. */
    int     i_payload;
    /* If param->b_annexb is set, Annex-B bytestream with startcode.
     * Otherwise, startcode is replaced with a 4-byte size.
     * This size is the size used in mp4/similar muxing; it is equal to i_payload-4 */
    uint8_t *p_payload;

    /* Size of padding in bytes. */
    int i_padding;
} ten264_nal_t;

/****************************************************************************
 * Encoder parameters
 ****************************************************************************/

#define TEN264_CSP_MASK           0x00ff  /* */
#define TEN264_CSP_NONE           0x0000  /* Invalid mode     */
#define TEN264_CSP_I400           0x0001  /* monochrome 4:0:0 */
#define TEN264_CSP_I420           0x0002  /* yuv 4:2:0 planar */
#define TEN264_CSP_YV12           0x0003  /* yvu 4:2:0 planar */
#define TEN264_CSP_NV12           0x0004  /* yuv 4:2:0, with one y plane and one packed u+v */
#define TEN264_CSP_NV21           0x0005  /* yuv 4:2:0, with one y plane and one packed v+u */
#define TEN264_CSP_I422           0x0006  /* yuv 4:2:2 planar */
#define TEN264_CSP_YV16           0x0007  /* yvu 4:2:2 planar */
#define TEN264_CSP_NV16           0x0008  /* yuv 4:2:2, with one y plane and one packed u+v */
#define TEN264_CSP_YUYV           0x0009  /* yuyv 4:2:2 packed */
#define TEN264_CSP_UYVY           0x000a  /* uyvy 4:2:2 packed */
#define TEN264_CSP_V210           0x000b  /* 10-bit yuv 4:2:2 packed in 32 */
#define TEN264_CSP_I444           0x000c  /* yuv 4:4:4 planar */
#define TEN264_CSP_YV24           0x000d  /* yvu 4:4:4 planar */
#define TEN264_CSP_BGR            0x000e  /* packed bgr 24bits */
#define TEN264_CSP_BGRA           0x000f  /* packed bgr 32bits */
#define TEN264_CSP_RGB            0x0010  /* packed rgb 24bits */
#define TEN264_CSP_MAX            0x0011  /* end of list */
#define TEN264_CSP_VFLIP          0x1000  /* the csp is vertically flipped */
#define TEN264_CSP_HIGH_DEPTH     0x2000  /* the csp has a depth of 16 bits per pixel component */

/* Slice type */
#define TEN264_TYPE_AUTO          0x0000  /* Let ten264 choose the right type */
#define TEN264_TYPE_IDR           0x0001
#define TEN264_TYPE_I             0x0002
#define TEN264_TYPE_P             0x0003
#define TEN264_TYPE_BREF          0x0004  /* Non-disposable B-frame */
#define TEN264_TYPE_B             0x0005
#define TEN264_TYPE_KEYFRAME      0x0006  /* IDR or I depending on b_open_gop option */
#define IS_TEN264_TYPE_I(x) ((x)==TEN264_TYPE_I || (x)==TEN264_TYPE_IDR || (x)==TEN264_TYPE_KEYFRAME)
#define IS_TEN264_TYPE_B(x) ((x)==TEN264_TYPE_B || (x)==TEN264_TYPE_BREF)

/* Log level */
#define TEN264_LOG_NONE          (-1)
#define TEN264_LOG_ERROR          0
#define TEN264_LOG_WARNING        1
#define TEN264_LOG_INFO           2
#define TEN264_LOG_DEBUG          3

#define TEN264_RC_CQP                  0
#define TEN264_RC_CRF                  1
#define TEN264_RC_ABR                  2
#define TEN264_NAL_SEI        6,

/* Threading */
#define TEN264_THREADS_AUTO 0 /* Automatically select optimal number of threads */
#define TEN264_SYNC_LOOKAHEAD_AUTO (-1) /* Automatically select optimal lookahead thread buffer size */
#define TEN264_BUILD 2
typedef struct ten264_zone_t
{
    int i_start, i_end;
    int b_force_qp;
    int i_qp;
    float f_bitrate_factor;
    struct ten264_param_t *param;
} ten264_zone_t;

typedef struct ten264_param_t
{
    uint32_t    cpu;
    int         i_threads;
    int         i_lookahead_threads;
    int         b_sliced_threads;
    int         b_deterministic;
    int         b_cpu_independent;
    int         i_sync_lookahead;


    int         i_width;
    int         i_height;
    int         i_csp;
    int         i_bitdepth;
    int         i_level_idc;
    int         i_frame_total;
    int         i_nal_hrd;

    struct
    {
        int         i_sar_height;
        int         i_sar_width;

        int         i_overscan;

        int         i_vidformat;
        int         b_fullrange;
        int         i_colorprim;
        int         i_transfer;
        int         i_colmatrix;
        int         i_chroma_loc;
    } vui;

    int         i_frame_reference;
    int         i_dpb_size;
    int         i_keyint_max;
    int         i_keyint_min;
    int         i_scenecut_threshold;
    int         b_intra_refresh;

    int         i_bframe;
    int         i_bframe_adaptive;
    int         i_bframe_bias;
    int         i_bframe_pyramid;
    int         b_open_gop;
    int         b_bluray_compat;
    int         i_avcintra_class;
    int         i_avcintra_flavor;

    int         b_deblocking_filter;
    int         i_deblocking_filter_alphac0;
    int         i_deblocking_filter_beta;

    int         b_cabac;
    int         i_cabac_init_idc;

    int         b_interlaced;
    int         b_constrained_intra;

    int         i_cqm_preset;
    char        *psz_cqm_file;
    uint8_t     cqm_4iy[16];
    uint8_t     cqm_4py[16];
    uint8_t     cqm_4ic[16];
    uint8_t     cqm_4pc[16];
    uint8_t     cqm_8iy[64];
    uint8_t     cqm_8py[64];
    uint8_t     cqm_8ic[64];
    uint8_t     cqm_8pc[64];

    void        (*pf_log)( void *, int i_level, const char *psz, va_list );
    void        *p_log_private;
    int         i_log_level;
    int         b_full_recon;
    char        *psz_dump_yuv;

    struct
    {
        unsigned int intra;
        unsigned int inter;

        int          b_transform_8x8;
        int          i_weighted_pred;
        int          b_weighted_bipred;
        int          i_direct_mv_pred;
        int          i_chroma_qp_offset;

        int          i_me_method;
        int          i_me_range;
        int          i_mv_range;
        int          i_mv_range_thread;
        int          i_subpel_refine;
        int          b_chroma_me;
        int          b_mixed_references;
        int          i_trellis;
        int          b_fast_pskip;
        int          b_dct_decimate;
        int          i_noise_reduction;
        float        f_psy_rd;
        float        f_psy_trellis;
        int          b_psy;
        int          b_mb_info;
        int          b_mb_info_update;

        int          i_luma_deadzone[2];

        int          b_psnr;
        int          b_ssim;
    } analyse;

    int b_p_optimize;
    int b_p_opt_analyse_cplx;
    int i_p_opt_period;
    float i_p_opt_offset;

    struct
    {
        int         i_rc_method;

        int         i_qp_constant;
        int         i_qp_min;
        int         i_qp_max;
        int         i_qp_step;

        int         i_bitrate;
        float       f_rf_constant;
        float       f_rf_constant_max;
        float       f_rate_tolerance;
        int         i_vbv_max_bitrate;
        int         i_vbv_buffer_size;
        float       f_vbv_buffer_init;
        float       f_ip_factor;
        float       f_pb_factor;

        int         b_filler;

        int         i_aq_mode;
        float       f_aq_strength;
        int         b_mb_tree;
        int         i_lookahead;

        int         b_stat_write;
        char        *psz_stat_out;
        int         b_stat_read;
        char        *psz_stat_in;

        float       f_qcompress;
        float       f_qblur;
        float       f_complexity_blur;
        ten264_zone_t *zones;
        int         i_zones;
        char        *psz_zones;
    } rc;

    struct
    {
        int i_left;
        int i_top;
        int i_right;
        int i_bottom;
    } crop_rect;

    int i_frame_packing;

    struct
    {
        int b_mastering_display;
        int i_green_x;
        int i_green_y;
        int i_blue_x;
        int i_blue_y;
        int i_red_x;
        int i_red_y;
        int i_white_x;
        int i_white_y;
        int64_t i_display_max;
        int64_t i_display_min;
    } mastering_display;

    struct
    {
        int b_cll;
        int i_max_cll;
        int i_max_fall;
    } content_light_level;

    int i_alternative_transfer;

    int b_aud;
    int b_repeat_headers;
    int b_annexb;
    int i_sps_id;
    int b_vfr_input;
    int b_pulldown;
    uint32_t i_fps_num;
    uint32_t i_fps_den;
    uint32_t i_timebase_num;
    uint32_t i_timebase_den;

    int b_tff;
    int b_pic_struct;
    int b_fake_interlaced;
    int b_stitchable;

    int b_opencl;
    int i_opencl_device;
    void *opencl_device_id;
    char *psz_clbin_file;

    int i_slice_max_size;
    int i_slice_max_mbs;
    int i_slice_min_mbs;
    int i_slice_count;
    int i_slice_count_max;
    void (*param_free)( void* );
    void (*nalu_process)( ten264_t *h, ten264_nal_t *nal, void *opaque );
    /* For internal use only */
    void *opaque;
} ten264_param_t;
/****************************************************************************
 * H.264 level restriction information
 ****************************************************************************/

typedef struct ten264_level_t
{
    uint8_t  level_idc;
    int32_t  mbps;
    int32_t  frame_size;
    int32_t  dpb;
    int32_t  bitrate;
    int32_t  cpb;
    uint16_t mv_range;
    uint8_t  mvs_per_2mb;
    uint8_t  slice_rate;
    uint8_t  mincr;
    uint8_t  bipred8x8;
    uint8_t  direct8x8;
    uint8_t  frame_only;
} ten264_level_t;

#define TEN264_PARAM_BAD_NAME  (-1)
#define TEN264_PARAM_BAD_VALUE (-2)
#define TEN264_PARAM_ALLOC_FAILED (-3)

extern const int ten264_chroma_format;

typedef struct ten264_hrd_t
{
    double cpb_initial_arrival_time;
    double cpb_final_arrival_time;
    double cpb_removal_time;

    double dpb_output_time;
} ten264_hrd_t;
typedef struct ten264_sei_payload_t
{
    int payload_size;
    int payload_type;
    uint8_t *payload;
} ten264_sei_payload_t;

typedef struct ten264_sei_t
{
    int num_payloads;
    ten264_sei_payload_t *payloads;
    /* In: optional callback to free each payload AND ten264_sei_payload_t when used. */
    void (*sei_free)( void* );
} ten264_sei_t;

typedef struct ten264_image_t
{
    int     i_csp;       /* Colorspace */
    int     i_plane;     /* Number of image planes */
    int     i_stride[4]; /* Strides for each plane */
    uint8_t *plane[4];   /* Pointers to each plane */
} ten264_image_t;

typedef struct ten264_image_properties_t
{
    float *quant_offsets;
    void (*quant_offsets_free)( void* );
    uint8_t *mb_info;
    void (*mb_info_free)( void* );
    #define TEN264_MBINFO_CONSTANT   (1U<<0)
    double f_ssim;
    double f_psnr_avg;
    double f_psnr[3];
    double f_crf_avg;
} ten264_image_properties_t;

typedef struct ten264_picture_t
{
    int     i_type;
    int     i_qpplus1;
    int     i_pic_struct;
    int     b_keyframe;
    int64_t i_pts;
    int64_t i_dts;
    ten264_param_t *param;
    ten264_image_t img;
    ten264_image_properties_t prop;
    ten264_hrd_t hrd_timing;
    ten264_sei_t extra_sei;
    void *opaque;
} ten264_picture_t;

/****************************************************************************
 * Encoder functions
 ****************************************************************************/

extern const ten264_level_t ten264_levels[];

/**
 * @brief init ten264_picture_t structure
 * 
 * @param pic[out] the ten264_picture_t structure
 */
void ten264_picture_init( ten264_picture_t *pic );

/**
 * @brief init ten264_param_t structure
 * 
 * @param t[out] the ten264_param_t structure
 */
void ten264_param_default( ten264_param_t *t);

/**
 * @brief parse a param, and set to the ten264_param_t structure
 * 
 * @param t[out] the ten264_param_t structure
 * @param name[in] param name
 * @param value[in] param value
 * @return int, 0: success, other: failure
 */
int ten264_param_parse( ten264_param_t *t, const char *name, const char *value );

static const char * const ten264_preset_names[] = { "ultrafast", "superfast", "veryfast", "faster", "fast", "medium", "slow", "slower", "veryslow", "placebo", 0 };
static const char * const ten264_profile_names[] = { "baseline", "main", "high", "high10", "high422", "high444", 0 };

/**
 * @brief apply profile to ten264_param_t structure
 * 
 * @param t[out] the ten264_param_t structure
 * @param profile[in] must in ten264_profile_names
 * @return int, 0: success, other: failure
 */
int ten264_param_apply_profile( ten264_param_t *t, const char *profile );

/**
 * @brief apply preset to ten264_param_t structure
 * 
 * @param t[out] the ten264_param_t structure
 * @param preset[in] must in ten264_preset_names
 * @return int, 0: success, other: failure
 */
int ten264_param_default_preset( ten264_param_t *t, const char *preset);

#define ten264_encoder_glue1(x,y) x##y
#define ten264_encoder_glue2(x,y) ten264_encoder_glue1(x,y)
#define ten264_encoder_open ten264_encoder_glue2(ten264_encoder_open_,TEN264_BUILD)
/**
 * @brief open an encoder with ten264_param_t structure
 * 
 * @param t[in] the ten264_param_t structure
 * @param ext_para[out] sdk lincense auth handler
 * @param config[in] sdk config file path
 * @return ten264_t* the encoder handler, NULL on failure
 */
ten264_t *ten264_encoder_open( ten264_param_t *t, void **ext_para, const char *config);

/**
 * @brief reconfig an encoder with ten264_param_t structure
 * 
 * @param t[in] the encoder handler 
 * @param para[in] the ten264_param_t structure
 * @return int, 0: success, other: failure
 */
int ten264_encoder_reconfig( ten264_t *t, ten264_param_t *para);

/**
 * @brief return the SPS and PPS that will be used for the whole stream.
 *      returns the number of bytes in the returned NALs.
 *      returns negative on error.
 *      the payloads of all output NALs are guaranteed to be sequential in memory.
 * 
 * @param t[in] the encoder handler 
 * @param pp_nal[out] the output NAL headers
 * @param pi_nal[out] the number of NAL units outputted in pp_nal
 * @return int 
 */
int ten264_encoder_headers( ten264_t *t, ten264_nal_t **pp_nal, int *pi_nal );

/**
 * @brief encode one picture.
 *      returns the number of bytes in the returned NALs.
 *      returns negative on error and zero if no NAL units returned.
 *      the payloads of all output NALs are guaranteed to be sequential in memory.
 * 
 * @param t[in] the encoder handler 
 * @param pp_nal[out] the output NAL units
 * @param pi_nal[out] the number of NAL units outputted in pp_nal
 * @param pic_in[out] input picture
 * @param pic_out[out] output picture
 * @param non_mono[in] no use, send NULL
 * @param motion[in] no use, send 0
 * @param texture[in] no use, send 0
 * @param ext_para[in] sdk lincense auth handler
 * @return int 
 */
int ten264_encoder_encode( ten264_t *t, ten264_nal_t **pp_nal, int *pi_nal, ten264_picture_t *pic_in, ten264_picture_t *pic_out,
        int *non_mono, double motion, double texture, void **ext_para);

/**
 * @brief close an encoder
 * 
 * @param t[in] the encoder handler 
 * @param ext_para[in] sdk lincense auth handler
 */
void ten264_encoder_close( ten264_t *t, void **ext_para);

/**
 * @brief return the number of currently delayed (buffered) frames
 *        this should be used at the end of the stream, to know when you have all the encoded frames.
 * 
 * @param t[in] the encoder handler 
 * @return int, num of delayed (buffered) frames
 */
int ten264_encoder_delayed_frames( ten264_t *t );

#ifdef __cplusplus
}
#endif


/****************************************************************************
 * ten266
 ****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/** TEN266 encoder handle */
typedef struct TEN266EncImpl* TEN266EncEncoderHandle;

/** Max psnr channels */
#define TEN266_ENC_MAX_PSNR_CHANNELS 3

/**  Max tiles per column */
#define TEN266_ENC_MAX_VER_TILES 20

/** Max tiles per row */
#define TEN266_ENC_MAX_HOR_TILES 22

/**
 * @enum TEN266EncStatus
 * @brief TEN266 encoder status
 */
typedef enum {
  kTEN266EncOk = 0,            /**< operation succeed */
  KTEN266EncOutputNotReady,    /**< encoder output is not ready */
  kTEN266EncErrorNullPointer,  /**< null pointer */
  kTEN266EncErrorInvalidParam, /**< invalid input parameter */
  kTEN266EncErrorOutOfMemory,  /**< memory failure */
  kTEN266EncErrorNotSupported, /**< feature not supported yet */
  kTEN266EncErrorUnexpected    /**< unexpected error */
} TEN266EncStatus;

/**
 * @enum TEN266EncChromaFormat
 * @brief TEN266 encoder chroma format
 */
typedef enum {
  kTEN266EncChromaFormat400 = 0,
  kTEN266EncChromaFormat420 = 1,
  kTEN266EncChromaFormat422 = 2,
  kTEN266EncChromaFormat444 = 3,
} TEN266EncChromaFormat;

/**
 * @enum TEN266EncRateControlMode
 * @brief TEN266 encoder rate control mode
 */
typedef enum {
  kTEN266EncRateControlCQP = 0,
  kTEN266EncRateControlABR = 1,
  kTEN266EncRateControlCRF = 2,
  kTEN266EncRateControlCRFVBV = 3
} TEN266EncRateControlMode;

/**
 * @enum TEN266EncAdaptiveQuantMode
 * @brief TEN266 encoder adaptive quant mode
 */
typedef enum {
  kTEN266EncAdaptiveQuantNone = 0,
  kTEN266EncAdaptiveQuantVariance = 1,
  kTEN266EncAdaptiveQuantAutoVariance = 2,
  kTEN266EncAdaptiveQuantAutoVarianceBiased = 3,
} TEN266EncAdaptiveQuantMode;

#define TEN266_ENC_MAX_GOP_SIZE 32 /**< max number of pictures inside a GoP */
#define TEN266_ENC_MAX_REF_PICS 16 /**< max reference pictures */

/**
 * @enum TEN266EncPicType
 * @brief TEN266 picture type
 */
typedef enum {
  kTEN266EncPicTypeB = 0,
  kTEN266EncPicTypeP = 1,
  kTEN266EncPicTypeI = 2
} TEN266EncPicType;

/**
 * @enum TEN266EncPreset
 * @brief TEN266 preset
 */
typedef enum {
  kTEN266EncPresetExperimental = -1,
  kTEN266EncPresetSlowest = 0,
  kTEN266EncPresetSlower = 1,
  kTEN266EncPresetSlow = 2, /**< target fhd 1fps */
  kTEN266EncPresetMedium = 3,
  kTEN266EncPresetFast = 4,
  kTEN266EncPresetFaster = 5,
  kTEN266EncPresetVeryFast = 6, /**< target fhd 30fps */
  kTEN266EncPresetFastest = 7,
  kTEN266EncPresetMax = 63
} TEN266EncPreset;

/**
 * @struct TEN266EncGop
 * @brief H266 gop configuration
 */
typedef struct {
  int32_t poc;                      /**< picture order count */
  int8_t temporal_id;               /**< picture temporal hierarchy id */
  TEN266EncPicType pic_type;          /**< picture type I/P/B */
  int8_t qp_offset;                 /**< qp offset */
  double qp_model_offset;           /**< linear qp offset model, offset */
  double qp_model_scale;            /**< linear qp offset model, scale */
  int8_t num_ref_pics_active_list0; /**< number of active ref pictures in list0 */
  /** number of ref pictures(used for current and furture) in list0 */
  int8_t num_ref_pics_list0;
  /** delta poc of ref pictures in list0, number of valid entries = num_ref_pic_list0 */
  int8_t delta_ref_poc_list0[TEN266_ENC_MAX_REF_PICS];
  int8_t num_ref_pics_active_list1; /**< number of active ref pictures in list1 */
  /** number of ref pictures(used for current and furture) in list1 */
  int8_t num_ref_pics_list1;
  /** delta poc of ref pictures in list1, number of valid entries = num_ref_pic_list1 */
  int8_t delta_ref_poc_list1[TEN266_ENC_MAX_REF_PICS];
} TEN266EncGop;

/**
 * @struct TEN266EncConfWindow
 * @brief TEN266 encoder picture conformance window
 */
typedef struct {
  // @todo combine with TEN266DecConfWindow
  int32_t right_offset;  /**< Conformance window right offset */
  int32_t bottom_offset; /**< Conformance window bottom offset */
  int pad[2];            /**< number of padded pixels for width and height */
} TEN266EncConfWindow;

/**
 * @struct TEN266EncRcConfig
 * @brief TEN266 encoder rate control configuration
 */
typedef struct {
  int8_t qp_init_min;           /**< min qp init */
  int8_t qp_init_max;           /**< max qp init */
  int32_t vbv_max_bitrate;      /**< vbv max bitrate */
  int32_t vbv_buffer_size;      /**< vbv buffer size */
  double vbv_buffer_init;     /**< Initial VBV buffer occupancy (fraction of bufsize or in kbits) */
  double crf_max;             /**< max CRF value */
  double crf_min;             /**< min CRF value */
} TEN266EncRcConfig;

/**
 * @struct TEN266EncConfig
 * @brief TEN266 encoder configuration
 */
typedef struct {
  /* preset */
  TEN266EncPreset preset; /**< enum indicating preset */

  /* Input */
  int32_t width;                     /**< source width in pixel */
  int32_t height;                    /**< source height in pixel */
  TEN266EncChromaFormat chroma_format; /**< chroma format */
  int8_t input_bit_depth;            /**< bit depth of the source yuv */
  int32_t fps_num;                   /**< frame rate numerator */
  int32_t fps_denom;                 /**< frame rate denominator */
  /** set to true if input pictures are allocated and sent from external, set to false
      then encoder will allocate and manage the input pictures */
  bool use_external_input;

  /* Output */
  int8_t output_bit_depth; /**< output bit depth */
  bool enable_stat;        /**< enable statistics */
  bool enable_aud;         /**< enable au delimiter */
  /** set to true to enable writing headers(parameter sets) before every intra frame,
      false to only write headers at the beginning of sequence */
  bool enable_repeating_headers;

  /* Coding structure */
  /** intra frame period, 0 means only the first frame is I */
  int32_t intra_period;
  /** idr frame period, 0 means only the first frame is IDR */
  int32_t idr_period;
  int32_t frames_to_encode;  /**< frames to encode */
  int8_t gop_size;           /**< GOP size of hierarchical prediction structure */

  int32_t lookahead_depth;   /**< look ahead depth */
  TEN266EncGop gop_structure[TEN266_ENC_MAX_GOP_SIZE]; /**< user defined gop structure  */
  int8_t qp_in_val[3][112];                        /**< Input coordinates for the QP tables */
  int8_t qp_out_val[3][112];                       /**< Output coordinates for the QP tables */
  int8_t number_in_qp[3];                    /**< number of input delta qp */
  int8_t number_out_qp[3];                   /**< number of output delta qp */

  /* tiles support */
  bool enable_pic_partition;                        /**< multiple tiles and slices per picture */
  int8_t tile_width_array[TEN266_ENC_MAX_HOR_TILES];  /**< ctus per tile  array */
  int8_t tile_height_array[TEN266_ENC_MAX_VER_TILES]; /**< ctus per tile  array  */

  /* Rate control and dQp */
  TEN266EncRateControlMode rc_mode;      /**< rate control mode */
  bool rc_cu_tree;                     /**< enable cuTree QpOffset */
  TEN266EncAdaptiveQuantMode rc_aq_mode; /**< rate control AQ mode */
  /** Adjust the strength of the AQ offsets. 0 means disables AQ, high value will lead to high QP
     offsets resulting in a large difference in achieved bitrates. Default 1.0. Range of
     values:[0.0, 3.0] */
  double aq_strength;
  int8_t qp;                  /**< qp use for CQP rate control */
  int32_t bitrate;            /**< target bitrate for CBR rate control */
  int8_t crf;                 /**< target rate factor for CRF coding */
  int8_t max_delta_qp;        /**< Max absolute delta QP (1:default) */
  int8_t max_cu_dqp_subdiv;   /**< Max subdiv for CU luma Qp adjustment */
  int8_t max_delta_qp_depth;  /**< Max depth of a minimum CuDQP for sub-LCU-level delta */

  /* Parallelism features */
  bool enable_wpp;                /**< enable wavefront processing */
  int num_pool_threads;           /**< number of encoder threads */
  int num_frame_threads;          /**< number of concurrently encoded frames */
  bool enable_thread_priority;    /**< enable threads high priority */

  /* Paritition : CTU/minCB/QT/BT/TT */
  int8_t log2_ctu_size;                 /**< log2 of ctu size */
  int8_t log2_min_cb_size;              /**< log2 of min cb size */
  int8_t log2_min_qt_size_intra;        /**< log2 of min qt size for intra luma */
  int8_t log2_max_bt_size_intra;        /**< log2 of max bt size for intra luma */
  int8_t log2_max_tt_size_intra;        /**< log2 of max tt size for intra luma */
  int8_t max_mtt_depth_intra;           /**< max mtt depth for intra */
  int8_t log2_min_qt_size_inter;        /**< log2 of min qt size for inter */
  int8_t log2_max_bt_size_inter;        /**< log2 of max bt size for inter */
  int8_t log2_max_tt_size_inter;        /**< log2 of max tt size for inter */
  int8_t max_mtt_depth_inter;           /**< max mtt depth for inter */
  int8_t log2_min_qt_size_intra_chroma; /**< log2 of min qt size for intra chroma */
  int8_t log2_max_bt_size_intra_chroma; /**< log2 of max bt size for intra chroma */
  int8_t log2_max_tt_size_intra_chroma; /**< log2 of max tt size for intra chroma */
  int8_t max_mtt_depth_intra_chroma;    /**< max mtt depth for intra chroma */
  bool max_tu_size_64;                  /**< flag to tell if max tu size is 64 */
  int8_t max_cu_size;                   /**< default:64 */

  /* Coding tools : Intra */
  bool enable_dual_tree; /**< enable intra luma/chroma dual tree */
  bool enable_isp;       /**< enable intra subpartition */
  bool enable_mip;       /**< enable mip */
  bool enable_mrl;       /**< enable intra luma multi reference line */
  bool enable_cclm;      /**< enable cross compoment linear model */
  bool enable_ibc;       /**< enable ibc */
  bool enable_bdpcm;     /**< enable bdpcm */

  /* Coding tools : Inter */
  bool enable_affine;               /**< enable inter affine */
  bool enable_prof;                 /**< enable affine PROF */
  bool affine_type;                 /**< inter affine type */
  int8_t max_merge_cand;            /**< maximal inter merge candidates */
  int8_t max_affine_merge_cand;     /**< maximal inter affine merge candidates */
  int8_t max_ibc_merge_cand;        /**< maximal ibc merge candidates */
  int8_t log2_parallel_merge_level; /**< log2 of parellel merge level */

  bool enable_gpm;        /**< enable geometric parition */
  int8_t max_gpm_cand;    /**< maximal gpm candidates  */
  bool enable_mmvd;       /**< Merge mode with motion vector difference */
  bool disable_frac_mmvd; /**< Disable fractional MVD in MMVD mode adaptively */
  bool enable_tmvp;       /**< tmvp mode, 0 off, 1 on */
  bool enable_sbtmvp;     /**< sbtmvp mode, 0 off, 1 on */
  bool enable_ciip;       /**< enable ciip, both intra and merge are needed */
  bool enable_cabac_init; /**< cabac init model choice from p/b, default is on */
  bool enable_amvr;       /**< enable amvr mode */
  bool enable_dmvr;       /**< enable dmvr mode */
  bool enable_bdof;       /**< enable bdof mode */
  bool enable_smvd;       /**< enable smvd mode */
  bool enable_bcw;        /**< enable bcw mode */

  /* Coding tools : TrQuant */
  bool enable_dep_quant;                      /**< enable dep quant */
  bool enable_joint_chroma;                   /**< enable joint chroma residual coding */
  bool enable_ladf;                           /**< enable ladf */
  bool enable_lfnst;                          /**< enable lfnst */
  bool enable_mts;                            /**< enable mts */
  bool enable_explicit_mts_inter;             /**< enable explicit mts inter */
  bool enable_explicit_mts_intra;             /**< enable explicit mts intra */
  bool enable_lmcs;                           /**< enable lmcs */
  bool enable_chroma_scale;                   /**< enable chroma scale */
  bool enable_sbt;                            /**< enable sbt */
  bool enable_sign_hiding;                    /**< enable sign hiding */
  bool enable_transform_skip;                 /**< enable transform skip */
  bool enable_transform_skip_residual_coding; /**< enable transform skip residual coding */

  int8_t log2_ts_max_size;   /**< Transform skip log2 max size */
  int8_t mts_inter_max_cand; /**< Number of additional MTS candidates for inter slices */
  int8_t mts_intra_max_cand; /**< Number of additional MTS candidates for intra slices */

  /* Coding tools : In-loop filter */
  bool enable_alf;             /**< enable adaptive loop filter */
  bool enable_ccalf;           /**< enable ccalf */
  bool enable_dblk;            /**< enable deblock filter */
  bool enable_sao;             /**< enable sao */
  bool enable_temporal_filter; /**< enable temporal filter */

  /* conformance window mode */
  TEN266EncConfWindow conf_window; /**< conformance window parameter */

  /* rate control config */
  TEN266EncRcConfig rc_param; /**< struct containing rate control configs */
} TEN266EncConfig;

/**
 * @struct TEN266EncPicture
 * @brief TEN266 encoder picture structure
 */
typedef struct {
  int32_t width;                     /**< picture width in number of pixels */
  int32_t height;                    /**< picture height in number of pixels */
  TEN266EncChromaFormat chroma_format; /**< picture chroma format */
  int8_t bit_depth;                  /**< bit depth */
  void* plane[3];                    /**< pointer to the first pixel for each plane @todo const*/
  int32_t stride[3];                 /**< line stride for each plane in bytes */
  int64_t ts;                        /**< timestamp */
} TEN266EncPicture;

/**
 * @enum TEN266EncNalType
 * @brief TEN266 encoder nal type
 */
typedef enum {
  kTEN266EncNalVps = 0,
  kTEN266EncNalSps,
  kTEN266EncNalPps,
  kTEN266EncNalAps,
  kTEN266EncNalAud,
  kTEN266EncNalSei,
  kTEN266EncNalSlice,
  kTEN266EncNalAlfAps,
  kTEN266EncNalLmcsAps,
  kTEN266EncNalMax
} TEN266EncNalType;

/**
 * @struct TEN266EncNal
 * @brief TEN266 encoder nal
 */
typedef struct {
  TEN266EncNalType nal_type; /**< nal type */
  int32_t payload_size;    /**< payload size */
  const uint8_t* payload;  /**< payload buffer */
} TEN266EncNal;

/**
 * @struct TEN266EncStat
 * @brief TEN266 encoder output statistics
 */
typedef struct {
  int32_t poc;                                 /**< picture order count */
  int8_t qp;                                   /**< picture level Qp */
  char slice_type;                             /**< picture type */
  bool scene_cut;                              /**< flag to indicate scene cut */
  int64_t used_bits;                           /**< raw frame bitstream size in bits */
  int64_t samples[TEN266_ENC_MAX_PSNR_CHANNELS]; /**< Number of samples, total/y/u/v */
  int64_t sse[TEN266_ENC_MAX_PSNR_CHANNELS];     /**< sum squared error, total/y/u/v */
  double psnr[TEN266_ENC_MAX_PSNR_CHANNELS];     /**< PSNR, total/y/u/v */
  float frame_enc_time; /**< frame encoding time, can be 0 if it is not available*/
} TEN266EncStat;

/**
 * @struct TEN266EncOutput
 * @brief TEN266 encoder output
 */
typedef struct {
  int64_t pts;                    /**< presentation time stamp */
  int64_t dts;                    /**< decode time stamp */
  int32_t num_nals;               /**< number of nals in the output buffer */
  TEN266EncNal nal[kTEN266EncNalMax]; /**< nal units */
  TEN266EncStat stat;               /**< statistics of output */
} TEN266EncOutput;

/**
 * Get default encoder configuration
 * @param[out] cfg Pointer to default encoder configuration
 * @return @ref TEN266EncStatus
 */
TEN266EncStatus TEN266EncGetDefaultConfig(TEN266EncConfig* cfg);

/**
 * Set one parameter by name.
 * @param[in] name parameter name string
 * @param[in] value parameter value string
 * @param[out] config updated configuration
 * @return @ref TEN266EncStatus
 */
TEN266EncStatus TEN266EncParseParam(const char* name, const char* value, TEN266EncConfig* config);

 /**
 * Initialize encoder.
 * @return @ref TEN266EncStatus
 */
TEN266EncStatus TEN266EncInitEncoder(TEN266EncEncoderHandle encoder);

  /**
 * Set one parameter by name. This function is for debugging only. Users should not call this
 * function, since it will be removed eventrually
 * @param[in] encoder encoder handle
 * @param[in] name parameter name string
 * @param[in] value parameter value string
 * @return @ref TEN266EncStatus
 */
TEN266EncStatus TEN266EncSetParam(TEN266EncEncoderHandle encoder, const char* name, const char* value);
/**
 * Create encoder instance. User should call this api first to obtain an encoder handle
 * @param[in] config Encoder configuration
 * @param[out] encoder Pointer to the created encoder handle
 * @return @ref TEN266EncStatus
 */
TEN266EncStatus TEN266EncCreateEncoder(const TEN266EncConfig* config, TEN266EncEncoderHandle* encoder);

/**
 * Query encoder library verison.
 * @param[in] encoder Encoder handle
 * @param[in] version_buf_size Size of verison buffer in bytes
 * @param[out] version_buf Buffer that encoder can use to fill version string
 * @return @ref TEN266EncStatus
 */
TEN266EncStatus TEN266EncGetVersion(TEN266EncEncoderHandle encoder, int32_t version_buf_size,
                                char* version_buf);

/**
 * Close encoder instance created by @ref TEN266EncCreateEncoder
 * @param[in] encoder Encoder handle
 * @return @ref TEN266EncStatus
 */
TEN266EncStatus TEN266EncCloseEncoder(TEN266EncEncoderHandle encoder);

/**
 * Give a picture to encoder to encode.
 * @param[in] encoder Encoder handle
 * @param[in] pic Pointer to the picture that needs to be encoded
 * @return @ref TEN266EncStatus
 */
TEN266EncStatus TEN266EncPutPicture(TEN266EncEncoderHandle encoder, const TEN266EncPicture* pic);

/**
 * Get a picture from encoder that client can use to fill picture data.
 * @param[in] encoder Encoder handle
 * @param[out] pic Pointer to picture that client can use to fill picture data
 * @return @ref TEN266EncStatus
 */
TEN266EncStatus TEN266EncGetPicture(TEN266EncEncoderHandle encoder, TEN266EncPicture* pic);

/**
 * Encode headers (SPS, PPS etc).
 * @param[in] encoder Encoder handle
 * @param[out] output Pointer to encoder output
 * @return @ref TEN266EncStatus.
 */
TEN266EncStatus TEN266EncEncodeHeaders(TEN266EncEncoderHandle encoder, TEN266EncOutput* output);

/**
 * Encode frame.
 * @param[in] encoder Encoder handle
 * @param[out] output Pointer to encoder output
 * @return @ref TEN266EncStatus.
 */
TEN266EncStatus TEN266EncEncodeFrame(TEN266EncEncoderHandle encoder, TEN266EncOutput* output);

/**
 * Flush encoder. Client should continue calling TEN266EncEncodeFrame after this API until it
 * reaches end of stream.
 * @param[in] encoder Encoder handle
 * @return @ref TEN266EncStatus.
 */
TEN266EncStatus TEN266EncFlush(TEN266EncEncoderHandle encoder);

#ifdef __cplusplus
}
#endif

/****************************************************************************
 * adpat filter strength
 ****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

float adapt_sharp_filter(float vquality);
int adapt_tve_filter(float vquality);
#ifdef __cplusplus
}
#endif

/****************************************************************************
 * hdr2sdr
 ****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

typedef struct wxmmhdr_color_param_t {
  int pri;
  int trc;
  int spc;
  int range;
  int fmt;
} wxmmhdr_color_param_t;

typedef struct wxmmhdr_init_param_t {
  wxmmhdr_color_param_t i, o;
  int use_threads;
  int use_assembly;
  int use_cuda;
} wxmmhdr_init_param_t;

typedef struct wxmmhdr_config_param_t {
  float src_highlight;
} wxmmhdr_config_param_t;

typedef void wxmmhdr_frame_translator_t;

wxmmhdr_frame_translator_t* wxmmhdr_open(wxmmhdr_init_param_t param);
void wxmmhdr_configure(wxmmhdr_frame_translator_t* handle, wxmmhdr_config_param_t param);
void wxmmhdr_process(wxmmhdr_frame_translator_t* handle, uint8_t* const src[3], const long src_stride[3], uint8_t* const dst[3], const long dst_stride[3],
                     unsigned int src_width, unsigned int src_height);
void wxmmhdr_close(wxmmhdr_frame_translator_t* handle);

#ifdef __cplusplus
}
#endif


#endif  // SOURCE_LIB_INC_TEN265_H_
